/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.filter.NamedFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerWithFilterAndProtobufTest")
public class ClientListenerWithFilterAndProtobufTest
extends MultiHotRodServersTest {
    private final int NUM_NODES = 2;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder defaultClusteredCacheConfig = ClientListenerWithFilterAndProtobufTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        defaultClusteredCacheConfig.encoding().key().mediaType("application/x-protostream");
        defaultClusteredCacheConfig.encoding().value().mediaType("application/x-protostream");
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)defaultClusteredCacheConfig);
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
        for (int i = 0; i < 2; ++i) {
            this.server(i).addCacheEventFilterFactory("custom-filter-factory", (CacheEventFilterFactory)new CustomCacheEventFilterFactory());
            MarshallerRegistration.registerMarshallers(ProtobufMetadataManagerImpl.getSerializationContextInternal((EmbeddedCacheManager)this.server(i).getCacheManager()));
            AssertJUnit.assertFalse((boolean)this.client(i).getCache("___protobuf_metadata").containsKey((Object)".errors"));
        }
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
        this.remoteCache = this.client(0).getCache();
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testEventFilter() throws Exception {
        Object[] filterFactoryParams = new Object[]{"string_key_1", "user_1"};
        ClientEntryListener listener = new ClientEntryListener();
        this.remoteCache.addClientListener((Object)listener, filterFactoryParams, null);
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        this.remoteCache.put((Object)"string_key_1", (Object)"string value 1");
        this.remoteCache.put((Object)"string_key_2", (Object)"string value 2");
        this.remoteCache.put((Object)"user_1", (Object)user1);
        AssertJUnit.assertEquals((int)3, (int)this.remoteCache.keySet().size());
        ClientCacheEntryCreatedEvent e = listener.createEvents.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"string_key_1", (Object)e.getKey());
        e = listener.createEvents.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"user_1", (Object)e.getKey());
        e = listener.createEvents.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertNull((String)"No more elements expected in queue!", (Object)e);
    }

    public static class CustomEventFilter
    implements CacheEventFilter<String, Object>,
    Serializable,
    ExternalPojo {
        private String firstParam;
        private String secondParam;

        public CustomEventFilter(String firstParam, String secondParam) {
            this.firstParam = firstParam;
            this.secondParam = secondParam;
        }

        public boolean accept(String key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return this.firstParam.equals(key) || this.secondParam.equals(key);
        }
    }

    @NamedFactory(name="custom-filter-factory")
    public static class CustomCacheEventFilterFactory
    implements CacheEventFilterFactory {
        public CacheEventFilter<String, Object> getFilter(Object[] params) {
            String firstParam = (String)params[0];
            String secondParam = (String)params[1];
            return new CustomEventFilter(firstParam, secondParam);
        }
    }

    @ClientListener(filterFactoryName="custom-filter-factory")
    public static class ClientEntryListener {
        public final BlockingQueue<ClientCacheEntryCreatedEvent> createEvents = new LinkedBlockingQueue<ClientCacheEntryCreatedEvent>();

        @ClientCacheEntryCreated
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCreatedEvent event) {
            this.createEvents.add(event);
        }
    }
}

