/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.RemoteCacheSupplier;
import org.infinispan.filter.NamedFactory;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;

@ClientListener
public class EventLogListener<K>
implements RemoteCacheSupplier<K> {
    public BlockingQueue<ClientCacheEntryCreatedEvent> createdEvents = new ArrayBlockingQueue<ClientCacheEntryCreatedEvent>(128);
    public BlockingQueue<ClientCacheEntryModifiedEvent> modifiedEvents = new ArrayBlockingQueue<ClientCacheEntryModifiedEvent>(128);
    public BlockingQueue<ClientCacheEntryRemovedEvent> removedEvents = new ArrayBlockingQueue<ClientCacheEntryRemovedEvent>(128);
    public BlockingQueue<ClientCacheEntryExpiredEvent> expiredEvents = new ArrayBlockingQueue<ClientCacheEntryExpiredEvent>(128);
    private final RemoteCache<K, ?> remote;

    public EventLogListener(RemoteCache<K, ?> remote) {
        this.remote = remote;
    }

    @Override
    public <V> RemoteCache<K, V> get() {
        return this.remote;
    }

    public <E extends ClientEvent> E pollEvent(ClientEvent.Type type) {
        try {
            ClientEvent event = (ClientEvent)this.queue(type).poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)event);
            return (E)event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <E extends ClientEvent> BlockingQueue<E> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedEvents;
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                return this.expiredEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    @ClientCacheEntryCreated
    public void handleCreatedEvent(ClientCacheEntryCreatedEvent e) {
        this.createdEvents.add(e);
    }

    @ClientCacheEntryModified
    public void handleModifiedEvent(ClientCacheEntryModifiedEvent e) {
        this.modifiedEvents.add(e);
    }

    @ClientCacheEntryRemoved
    public void handleRemovedEvent(ClientCacheEntryRemovedEvent e) {
        this.removedEvents.add(e);
    }

    @ClientCacheEntryExpired
    public void handleExpiriedEvent(ClientCacheEntryExpiredEvent e) {
        this.expiredEvents.add(e);
    }

    public void expectNoEvents() {
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectNoEvents(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                AssertJUnit.assertEquals((String)this.createdEvents.toString(), (int)0, (int)this.createdEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                AssertJUnit.assertEquals((String)this.modifiedEvents.toString(), (int)0, (int)this.modifiedEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                AssertJUnit.assertEquals((String)this.removedEvents.toString(), (int)0, (int)this.removedEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                AssertJUnit.assertEquals((String)this.expiredEvents.toString(), (int)0, (int)this.expiredEvents.size());
            }
        }
    }

    public void expectOnlyCreatedEvent(K key) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectOnlyModifiedEvent(K key) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectOnlyRemovedEvent(K key) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
    }

    public void expectOnlyExpiredEvent(K key) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectSingleEvent(K key, ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                ClientCacheEntryCreatedEvent createdEvent = (ClientCacheEntryCreatedEvent)this.pollEvent(type);
                TestingUtil.assertAnyEquals(key, (Object)createdEvent.getKey());
                TestingUtil.assertAnyEquals((Object)this.serverDataVersion(this.remote, key), (Object)createdEvent.getVersion());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                ClientCacheEntryModifiedEvent modifiedEvent = (ClientCacheEntryModifiedEvent)this.pollEvent(type);
                TestingUtil.assertAnyEquals(key, (Object)modifiedEvent.getKey());
                TestingUtil.assertAnyEquals((Object)this.serverDataVersion(this.remote, key), (Object)modifiedEvent.getVersion());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                ClientCacheEntryRemovedEvent removedEvent = (ClientCacheEntryRemovedEvent)this.pollEvent(type);
                TestingUtil.assertAnyEquals(key, (Object)removedEvent.getKey());
                break;
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                ClientCacheEntryExpiredEvent expiredEvent = (ClientCacheEntryExpiredEvent)this.pollEvent(type);
                TestingUtil.assertAnyEquals(key, (Object)expiredEvent.getKey());
            }
        }
        AssertJUnit.assertEquals((int)0, (int)this.queue(type).size());
    }

    private long serverDataVersion(RemoteCache<K, ?> cache, K key) {
        long v1 = cache.getVersioned(key).getVersion();
        long v2 = cache.getWithMetadata(key).getVersion();
        AssertJUnit.assertEquals((long)v1, (long)v2);
        return v1;
    }

    public void expectUnorderedEvents(ClientEvent.Type type, K ... keys) {
        ArrayList assertedKeys = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            Object event = this.pollEvent(type);
            int initialSize = assertedKeys.size();
            for (K key : keys) {
                Object eventKey = null;
                switch (event.getType()) {
                    case CLIENT_CACHE_ENTRY_CREATED: {
                        eventKey = ((ClientCacheEntryCreatedEvent)event).getKey();
                        break;
                    }
                    case CLIENT_CACHE_ENTRY_MODIFIED: {
                        eventKey = ((ClientCacheEntryModifiedEvent)event).getKey();
                        break;
                    }
                    case CLIENT_CACHE_ENTRY_REMOVED: {
                        eventKey = ((ClientCacheEntryRemovedEvent)event).getKey();
                        break;
                    }
                    case CLIENT_CACHE_ENTRY_EXPIRED: {
                        eventKey = ((ClientCacheEntryExpiredEvent)event).getKey();
                    }
                }
                this.checkUnorderedKeyEvent(assertedKeys, key, eventKey);
            }
            int finalSize = assertedKeys.size();
            AssertJUnit.assertEquals((int)(initialSize + 1), (int)finalSize);
        }
    }

    private boolean checkUnorderedKeyEvent(List<K> assertedKeys, K key, K eventKey) {
        if (key.equals(eventKey)) {
            AssertJUnit.assertFalse((boolean)assertedKeys.contains(key));
            assertedKeys.add(key);
            return true;
        }
        return false;
    }

    public void expectFailoverEvent() {
        this.pollEvent(ClientEvent.Type.CLIENT_CACHE_FAILOVER);
    }

    @NamedFactory(name="raw-static-filter-factory")
    public static class RawStaticCacheEventFilterFactory
    implements CacheEventFilterFactory {
        public CacheEventFilter<byte[], byte[]> getFilter(Object[] params) {
            return new RawStaticCacheEventFilter();
        }

        static class RawStaticCacheEventFilter
        implements CacheEventFilter<byte[], byte[]>,
        Serializable {
            final byte[] staticKey = new byte[]{3, 75, 0, 0, 0, 2};

            RawStaticCacheEventFilter() {
            }

            public boolean accept(byte[] key, byte[] previousValue, Metadata previousMetadata, byte[] value, Metadata metadata, EventType eventType) {
                return Arrays.equals(key, this.staticKey);
            }
        }
    }

    @NamedFactory(name="dynamic-filter-factory")
    public static class DynamicCacheEventFilterFactory
    implements CacheEventFilterFactory {
        public CacheEventFilter<Integer, String> getFilter(Object[] params) {
            return new DynamicCacheEventFilter(params);
        }

        static class DynamicCacheEventFilter
        implements CacheEventFilter<Integer, String>,
        Serializable {
            private final Object[] params;

            public DynamicCacheEventFilter(Object[] params) {
                this.params = params;
            }

            public boolean accept(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return this.params[0].equals(key);
            }
        }
    }

    @NamedFactory(name="static-filter-factory")
    public static class StaticCacheEventFilterFactory<K>
    implements CacheEventFilterFactory {
        private final K staticKey;

        public StaticCacheEventFilterFactory(K staticKey) {
            this.staticKey = staticKey;
        }

        public CacheEventFilter<K, String> getFilter(Object[] params) {
            return new StaticCacheEventFilter<K>(this.staticKey);
        }

        static class StaticCacheEventFilter<K>
        implements CacheEventFilter<K, String>,
        Serializable,
        ExternalPojo {
            final K staticKey;

            StaticCacheEventFilter(K staticKey) {
                this.staticKey = staticKey;
            }

            public boolean accept(K key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return this.staticKey.equals(key);
            }
        }
    }

    @ClientListener(filterFactoryName="dynamic-filter-factory", includeCurrentState=true)
    public static class DynamicFilteredEventLogWithStateListener<K>
    extends EventLogListener<K> {
        public DynamicFilteredEventLogWithStateListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(filterFactoryName="dynamic-filter-factory")
    public static class DynamicFilteredEventLogListener<K>
    extends EventLogListener<K> {
        public DynamicFilteredEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(filterFactoryName="static-filter-factory", includeCurrentState=true)
    public static class StaticFilteredEventLogWithStateListener<K>
    extends EventLogListener<K> {
        public StaticFilteredEventLogWithStateListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(filterFactoryName="raw-static-filter-factory", useRawData=true)
    public static class RawStaticFilteredEventLogListener<K>
    extends EventLogListener<K> {
        public RawStaticFilteredEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }

    @ClientListener(filterFactoryName="static-filter-factory")
    public static class StaticFilteredEventLogListener<K>
    extends EventLogListener<K> {
        public StaticFilteredEventLogListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }
}

