/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.CacheConfigurationException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="client.hotrod.near.InvalidatedNearCacheTest")
public class InvalidatedNearCacheTest
extends SingleHotRodServerTest {
    AssertsNearCache<Integer, String> assertClient;

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        this.assertClient = this.createAssertClient();
        return this.assertClient.manager;
    }

    protected <K, V> AssertsNearCache<K, V> createAssertClient() {
        ConfigurationBuilder builder = this.clientConfiguration();
        return AssertsNearCache.create(this.cache(), builder);
    }

    protected <K, V> RemoteCache<K, V> createClient() {
        ConfigurationBuilder builder = this.clientConfiguration();
        return new RemoteCacheManager(builder.build()).getCache();
    }

    private ConfigurationBuilder clientConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.nearCache().mode(this.getNearCacheMode()).maxEntries(-1);
        return builder;
    }

    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.INVALIDATED;
    }

    public void testGetNearCacheAfterConnect() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        RemoteCacheManager manager = new RemoteCacheManager(builder.build());
        RemoteCache cache = manager.getCache();
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        builder.nearCache().mode(this.getNearCacheMode()).maxEntries(-1);
        this.assertClient = AssertsNearCache.create(this.cache(), builder);
        AssertJUnit.assertEquals((int)2, (int)this.assertClient.remote.size());
        this.assertClient.expectNoNearEvents();
        this.assertClient.get(1, "one").expectNearGetValue(1, null).expectNearPutIfAbsent(1, "one");
        this.assertClient.get(2, "two").expectNearGetValue(2, null).expectNearPutIfAbsent(2, "two");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.remove(2).expectNearRemove(2, new AssertsNearCache[0]);
    }

    public void testGetNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.get(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.get(1, "v1").expectNearGetValue(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, null).expectNearGetNull(1);
    }

    public void testGetAsyncNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getAsync(1, null).expectNearGetNull(1);
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.getAsync(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getAsync(1, "v1").expectNearGetValue(1, "v1");
        this.assertClient.removeAsync(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getAsync(1, null).expectNearGetNull(1);
    }

    public void testGetVersionedNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getVersioned(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.getVersioned(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getVersioned(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getVersioned(1, null).expectNearGetNull(1);
    }

    public void testGetWithMetadataNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getWithMetadata(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.getWithMetadata(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getWithMetadata(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getWithMetadata(1, null).expectNearGetNull(1);
    }

    public void testGetWithMetadataAsyncNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getWithMetadataAsync(1, null).expectNearGetNull(1);
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.getWithMetadataAsync(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getWithMetadataAsync(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.removeAsync(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getWithMetadataAsync(1, null).expectNearGetNull(1);
    }

    public void testUpdateNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.put(1, "v2").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, "v2").expectNearGetNull(1).expectNearPutIfAbsent(1, "v2");
        this.assertClient.get(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.put(1, "v3").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
    }

    public void testUpdateAsyncNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.putAsync(1, "v2").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getAsync(1, "v2").expectNearGetNull(1).expectNearPutIfAbsent(1, "v2");
        this.assertClient.getAsync(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.putAsync(1, "v3").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.removeAsync(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.putAsync(1, "v4", 3L, TimeUnit.SECONDS).expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        this.assertClient.putAsync(1, "v5", 3L, TimeUnit.SECONDS, 3L, TimeUnit.SECONDS).expectNearRemove(1, new AssertsNearCache[0]);
    }

    public void testGetUpdatesNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        final AssertsNearCache newAsserts = this.createAssertClient();
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(newAsserts.manager){

            @Override
            public void call() {
                newAsserts.expectNoNearEvents();
                newAsserts.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
            }
        });
    }

    public void testGetAsyncUpdatesNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1, new AssertsNearCache[0]);
        final AssertsNearCache newAsserts = this.createAssertClient();
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(newAsserts.manager){

            @Override
            public void call() {
                newAsserts.expectNoNearEvents();
                try {
                    newAsserts.getAsync(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp=".*When enabling near caching, number of max entries must be configured.*")
    public void testConfigurationWithoutMaxEntries() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.nearCache().mode(this.getNearCacheMode());
        new RemoteCacheManager(builder.build());
    }

    public void testNearCacheNamePattern() {
        this.cacheManager.defineConfiguration("nearcache", new org.infinispan.configuration.cache.ConfigurationBuilder().build());
        ConfigurationBuilder builder = this.clientConfiguration();
        builder.nearCache().cacheNamePattern("near.*");
        RemoteCacheManager manager = new RemoteCacheManager(builder.build());
        RemoteCache nearcache = manager.getCache("nearcache");
        AssertJUnit.assertTrue((boolean)(nearcache instanceof InvalidatedNearRemoteCache));
        RemoteCache cache = manager.getCache();
        AssertJUnit.assertFalse((boolean)(cache instanceof InvalidatedNearRemoteCache));
    }
}

