/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.BlockingQueue;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.client.hotrod.near.NearCacheService;

public class MockNearCacheService<K, V>
extends NearCacheService<K, V> {
    final BlockingQueue<MockEvent> events;

    MockNearCacheService(NearCacheConfiguration cfg, BlockingQueue<MockEvent> events, ClientListenerNotifier listenerNotifier) {
        super(cfg, listenerNotifier);
        this.events = events;
    }

    protected NearCache<K, V> createNearCache(NearCacheConfiguration config) {
        NearCache delegate = super.createNearCache(config);
        return new MockNearCache(delegate, this.events);
    }

    static class MockClearEvent
    extends MockEvent {
        MockClearEvent() {
        }
    }

    static class MockRemoveEvent<K>
    extends MockEvent {
        final K key;

        MockRemoveEvent(K key) {
            this.key = key;
        }
    }

    static class MockGetEvent<K, V>
    extends MockKeyValueEvent<K, V> {
        MockGetEvent(K key, MetadataValue<V> value) {
            super(key, value);
        }
    }

    static class MockPutIfAbsentEvent<K, V>
    extends MockKeyValueEvent<K, V> {
        MockPutIfAbsentEvent(K key, MetadataValue<V> value) {
            super(key, value);
        }
    }

    static class MockPutEvent<K, V>
    extends MockKeyValueEvent<K, V> {
        MockPutEvent(K key, MetadataValue<V> value) {
            super(key, value);
        }
    }

    static class MockNearCache<K, V>
    implements NearCache<K, V> {
        final NearCache<K, V> delegate;
        final BlockingQueue<MockEvent> events;

        MockNearCache(NearCache<K, V> delegate, BlockingQueue<MockEvent> events) {
            this.delegate = delegate;
            this.events = events;
        }

        public void put(K key, MetadataValue<V> value) {
            this.delegate.put(key, value);
            this.events.add(new MockPutEvent<K, V>(key, value));
        }

        public void putIfAbsent(K key, MetadataValue<V> value) {
            this.delegate.putIfAbsent(key, value);
            this.events.add(new MockPutIfAbsentEvent<K, V>(key, value));
        }

        public boolean remove(K key) {
            boolean removed = this.delegate.remove(key);
            this.events.add(new MockRemoveEvent<K>(key));
            return removed;
        }

        public MetadataValue<V> get(K key) {
            MetadataValue value = this.delegate.get(key);
            this.events.add(new MockGetEvent(key, value));
            return value;
        }

        public void clear() {
            this.delegate.clear();
            this.events.clear();
            this.events.add(new MockClearEvent());
        }

        public int size() {
            return this.delegate.size();
        }
    }

    static abstract class MockKeyValueEvent<K, V>
    extends MockEvent {
        final K key;
        final MetadataValue<V> value;

        MockKeyValueEvent(K key, MetadataValue<V> value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.getClass().getName() + "{key=" + this.key + ", value=" + this.value + '}';
        }
    }

    static abstract class MockEvent {
        MockEvent() {
        }
    }
}

