/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.util.List;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.NotIndexedMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.Index;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.remote.impl.ProgrammaticSearchMappingProviderImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryDisableIndexingTest")
public class RemoteQueryDisableIndexingTest
extends AbstractQueryDslTest {
    private static final String NOT_INDEXED_PROTO_SCHEMA = "package sample_bank_account;\n/** @Indexed(false) */\nmessage NotIndexed {\n\toptional string notIndexedField = 1;\n}\n";
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;
    protected final String notIndexedProtoSchemaFile;

    protected RemoteQueryDisableIndexingTest(String notIndexedProtoSchemaFile) {
        this.notIndexedProtoSchemaFile = notIndexedProtoSchemaFile;
    }

    public RemoteQueryDisableIndexingTest() {
        this(NOT_INDEXED_PROTO_SCHEMA);
    }

    @BeforeClass
    protected void populateCache() {
        this.getCacheForWrite().put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.getCacheForWrite().put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected int getNodesCount() {
        return 1;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = this.getConfigurationBuilder();
        this.createClusteredCaches(this.getNodesCount(), cfg, true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.initProtoSchema(this.remoteCacheManager);
    }

    protected void initProtoSchema(RemoteCacheManager remoteCacheManager) throws IOException {
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"not_indexed.proto", (Object)this.notIndexedProtoSchemaFile);
        RemoteQueryTestUtils.checkSchemaErrors((RemoteCache<String, String>)metadataCache);
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        MarshallerRegistration.registerMarshallers(serCtx);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"not_indexed.proto", (String)this.notIndexedProtoSchemaFile));
        serCtx.registerMarshaller((BaseMarshaller)new NotIndexedMarshaller());
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testEmptyIndexIsPresent() {
        SearchIntegrator searchIntegrator = (SearchIntegrator)org.infinispan.query.Search.getSearchManager(this.cache).unwrap(SearchIntegrator.class);
        AssertJUnit.assertTrue((boolean)searchIntegrator.getIndexBindings().containsKey(ProtobufValueWrapper.INDEXING_TYPE));
        String indexName = ProgrammaticSearchMappingProviderImpl.getIndexName((String)this.cache.getName());
        AssertJUnit.assertNotNull((Object)searchIntegrator.getIndexManager(indexName));
        AssertJUnit.assertEquals((int)0, (int)searchIntegrator.getStatistics().getNumberOfIndexedEntities(ProtobufValueWrapper.class.getName()));
    }

    public void testEqNonIndexedType() {
        Query q = this.getQueryFactory().create("from sample_bank_account.NotIndexed where notIndexedField = 'testing 123'");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }
}

