/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.test.Exceptions;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="client.hotrod.retry.RetryOnFailureUnitTest")
public class RetryOnFailureUnitTest {
    private EventExecutor mockExecutor = (EventExecutor)Mockito.mock(EventExecutor.class, invocation -> {
        throw new UnsupportedOperationException(invocation.toString());
    });
    private Channel mockChannel = (Channel)Mockito.mock(Channel.class);

    public void testNoRetryOnTransportFailure() {
        this.doRetryTest(0, true);
    }

    public void testNoRetryOnExecuteFailure() {
        this.doRetryTest(0, false);
    }

    public void testSingleRetryOnTransportFailure() {
        this.doRetryTest(1, true);
    }

    public void testSingleRetryOnExecuteFailure() {
        this.doRetryTest(1, false);
    }

    public void testMultipleRetryOnTransportFailure() {
        this.doRetryTest(10, true);
    }

    public void testMultipleRetryOnExecuteFailure() {
        this.doRetryTest(10, false);
    }

    private void doRetryTest(int maxRetry, boolean failOnTransport) {
        ChannelFactory mockTransport = (ChannelFactory)Mockito.mock(ChannelFactory.class);
        Mockito.when((Object)mockTransport.getMaxRetries()).thenReturn((Object)maxRetry);
        Mockito.when((Object)mockTransport.trySwitchCluster((String)Mockito.any(), (byte[])Mockito.any())).thenReturn(CompletableFuture.completedFuture(ChannelFactory.ClusterSwitchStatus.NOT_SWITCHED));
        MockOperation mockOperation = new MockOperation(mockTransport, failOnTransport);
        ((EventExecutor)Mockito.doReturn((Object)true).when((Object)this.mockExecutor)).inEventLoop();
        ((EventExecutor)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(0)).run();
            return null;
        }).when((Object)this.mockExecutor)).execute((Runnable)Mockito.any(Runnable.class));
        ((Channel)Mockito.doReturn((Object)true).when((Object)this.mockChannel)).isActive();
        Exceptions.expectExceptionNonStrict(HotRodClientException.class, () -> {
            Void cfr_ignored_0 = (Void)Util.await((CompletableFuture)mockOperation.execute(), (long)10000L);
        });
        if (failOnTransport) {
            AssertJUnit.assertEquals((String)"Wrong getChannel() invocation.", (int)(maxRetry + 1), (int)mockOperation.channelInvocationCount.get());
            AssertJUnit.assertEquals((String)"Wrong execute() invocation.", (int)0, (int)mockOperation.executeInvocationCount.get());
        } else {
            AssertJUnit.assertEquals((String)"Wrong getChannel() invocation.", (int)(maxRetry + 1), (int)mockOperation.channelInvocationCount.get());
            AssertJUnit.assertEquals((String)"Wrong execute() invocation.", (int)(maxRetry + 1), (int)mockOperation.executeInvocationCount.get());
        }
    }

    private class MockOperation
    extends RetryOnFailureOperation<Void> {
        private final AtomicInteger channelInvocationCount;
        private final AtomicInteger executeInvocationCount;
        private final boolean failOnTransport;

        MockOperation(ChannelFactory channelFactory, boolean failOnTransport) {
            super((short)0, (short)0, null, channelFactory, null, null, 0, new ConfigurationBuilder().build(), null);
            this.failOnTransport = failOnTransport;
            this.channelInvocationCount = new AtomicInteger(0);
            this.executeInvocationCount = new AtomicInteger(0);
        }

        protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
            this.channelInvocationCount.incrementAndGet();
            if (this.failOnTransport) {
                this.cancel(null, (Throwable)new RemoteNodeSuspectException("Induced Failure", 1L, 1));
            } else {
                this.invoke(RetryOnFailureUnitTest.this.mockChannel);
            }
        }

        protected void executeOperation(Channel channel) {
            this.executeInvocationCount.incrementAndGet();
            if (!this.failOnTransport) {
                this.exceptionCaught(null, (Throwable)new RemoteNodeSuspectException("Induced Failure", 1L, 1));
            } else {
                this.complete(null);
            }
        }

        public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
            throw new UnsupportedOperationException();
        }
    }
}

