/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="org.infinispan.client.hotrod.stress.IterationStressTest")
public class IterationStressTest
extends SingleHotRodServerTest {
    private static final int NUM_ENTRIES = 500000;
    private static final String SERVER_HOST = "serverHost";
    public static final int THREADS = ProcessorInfo.availableProcessors();
    private RemoteCache<Object, Object> remoteCache;

    @Override
    protected void setup() throws Exception {
        String serverHost = System.getProperty(SERVER_HOST);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (serverHost == null) {
            this.cacheManager = this.createCacheManager();
            this.hotrodServer = this.createHotRodServer();
            builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        } else {
            builder.addServer().host(serverHost);
        }
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.remoteCacheManager.getCache();
        this.remoteCache = this.remoteCacheManager.getCache();
        AtomicInteger counter = new AtomicInteger();
        ExecutorService executorService = Executors.newFixedThreadPool(THREADS);
        CompletableFuture[] futures = new CompletableFuture[THREADS];
        IterationStressTest.timedExecution("Data ingestion", () -> {
            for (int i = 0; i < THREADS; ++i) {
                futures[i] = CompletableFuture.supplyAsync(() -> {
                    int c = counter.getAndIncrement();
                    while (c < 500000) {
                        this.remoteCache.put((Object)c, (Object)c);
                        c = counter.getAndIncrement();
                    }
                    return null;
                }, executorService);
            }
            CompletableFuture.allOf(futures).join();
        });
        IterationStressTest.timedExecution("Size", () -> {
            int size = this.remoteCache.size();
            System.out.printf("Ingested %d entries\n", size);
        });
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder));
    }

    private void warmup() {
        IntStream.range(0, 10).forEach(i -> this.iterate());
    }

    private void iterate() {
        AtomicInteger count = new AtomicInteger();
        CloseableIterator iterator = this.remoteCache.retrieveEntries(null, 1000);
        iterator.forEachRemaining(o -> count.getAndIncrement());
        iterator.close();
    }

    @Test
    public void testIteration() {
        IterationStressTest.timedExecution("warmup", this::warmup);
        IterationStressTest.timedExecution("iteration", this::iterate);
        IterationStressTest.timedExecution("close cache manager", () -> this.remoteCacheManager.stop());
    }

    private static void timedExecution(String label, Runnable code) {
        long start = System.currentTimeMillis();
        code.run();
        System.out.format("Run %s in %d ms\n", label, System.currentTimeMillis() - start);
    }
}

