/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;

@Immutable
public class GetKeyMultimapOperation<V>
extends AbstractKeyOperation<Collection<V>> {
    private int size;
    private Collection<V> result;

    public GetKeyMultimapOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, DataFormat dataFormat, ClientStatistics clientStatistics) {
        super((short)103, (short)104, codec, channelFactory, key, keyBytes, cacheName, topologyId, flags, cfg, dataFormat, clientStatistics);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendArrayOperation(channel, this.keyBytes);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result = null;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(Collections.emptySet());
            return;
        }
        if (this.result == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = new HashSet<V>(this.size);
        }
        while (this.result.size() < this.size) {
            Object value = MarshallerUtil.bytes2obj(this.channelFactory.getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat.isObjectStorage(), this.cfg.getClassWhiteList());
            this.result.add(value);
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

