/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Util;

public final class SegmentConsistentHash
implements ConsistentHash {
    private static final Log log = LogFactory.getLog(SegmentConsistentHash.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Hash hash = MurmurHash3.getInstance();
    private SocketAddress[][] segmentOwners;
    private int numSegments;
    private int segmentSize;

    @Override
    public void init(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, int hashSpace) {
    }

    public void init(SocketAddress[][] segmentOwners, int numSegments) {
        this.segmentOwners = segmentOwners;
        this.numSegments = numSegments;
        this.segmentSize = Util.getSegmentSize((int)numSegments);
    }

    @Override
    public SocketAddress getServer(Object key) {
        int segmentId = this.getSegment(key);
        SocketAddress server = this.segmentOwners[segmentId][0];
        if (trace) {
            log.tracef("Found server %s for segment %s of key %s", server, segmentId, Util.toStr((Object)key));
        }
        return server;
    }

    public int getSegment(Object key) {
        return this.getNormalizedHash(key) / this.segmentSize;
    }

    @Override
    public int getNormalizedHash(Object object) {
        return Util.getNormalizedHash((Object)object, (Hash)this.hash);
    }

    @Override
    public Map<SocketAddress, Set<Integer>> getSegmentsByServer() {
        HashMap<SocketAddress, Set> map = new HashMap<SocketAddress, Set>();
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            SocketAddress[] owners;
            for (SocketAddress s : owners = this.segmentOwners[segment]) {
                map.computeIfAbsent(s, k -> new HashSet()).add(segment);
            }
        }
        return Immutables.immutableMapWrap(map);
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public SocketAddress[][] getSegmentOwners() {
        return this.segmentOwners;
    }
}

