/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.protocol.Codec10;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class Codec11
extends Codec10 {
    private static final Log log = LogFactory.getLog(Codec11.class, Log.class);

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)11);
    }

    @Override
    protected Map<InetSocketAddress, Set<Integer>> computeNewHashes(ByteBuf buf, ChannelFactory channelFactory, Log localLog, int newTopologyId, int numKeyOwners, short hashFunctionVersion, int hashSpace, int clusterSize) {
        int numVirtualNodes = ByteBufUtil.readVInt(buf);
        if (this.trace) {
            localLog.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d, numVirtualNodes=%d", new Object[]{newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize, numVirtualNodes});
        }
        LinkedHashMap<InetSocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<InetSocketAddress, Set<Integer>>();
        ConsistentHash ch = null;
        if (hashFunctionVersion == 0) {
            localLog.trace("Not using a consistent hash function (version 0)");
        } else if (hashFunctionVersion == 1) {
            localLog.trace("Ignoring obsolete consistent hash function (version 1)");
        } else {
            ch = (ConsistentHash)channelFactory.getConsistentHashFactory().newConsistentHash(hashFunctionVersion);
        }
        for (int i = 0; i < clusterSize; ++i) {
            String host = ByteBufUtil.readString(buf);
            int port = buf.readUnsignedShort();
            int baseHashCode = buf.readIntLE();
            int normalizedHashCode = this.getNormalizedHash(baseHashCode, ch);
            if (this.trace) {
                localLog.tracef("Server(%s:%d) read with base hash code %d, and normalized hash code %d", new Object[]{host, port, baseHashCode, normalizedHashCode});
            }
            this.cacheHashCode(servers2Hash, host, port, normalizedHashCode);
            if (numVirtualNodes <= 1) continue;
            this.calcVirtualHashCodes(baseHashCode, numVirtualNodes, servers2Hash, host, port, ch);
        }
        return servers2Hash;
    }

    @Override
    public Log getLog() {
        return log;
    }

    private int getNormalizedHash(int baseHashCode, ConsistentHash ch) {
        if (ch != null) {
            return ch.getNormalizedHash(baseHashCode);
        }
        return baseHashCode;
    }

    private void calcVirtualHashCodes(int addrHashCode, int numVirtualNodes, Map<InetSocketAddress, Set<Integer>> servers2Hash, String host, int port, ConsistentHash ch) {
        for (int j = 1; j < numVirtualNodes; ++j) {
            int hashCode = this.calcVNodeHashCode(addrHashCode, j);
            this.cacheHashCode(servers2Hash, host, port, this.getNormalizedHash(hashCode, ch));
        }
    }

    private void cacheHashCode(Map<InetSocketAddress, Set<Integer>> servers2Hash, String host, int port, int hashCode) {
        InetSocketAddress address = InetSocketAddress.createUnresolved(host, port);
        Set<Integer> hashes = servers2Hash.get(address);
        if (hashes == null) {
            hashes = new HashSet<Integer>();
            servers2Hash.put(address, hashes);
        }
        hashes.add(hashCode);
        if (this.trace) {
            this.getLog().tracef("Hash code is: %d", hashCode);
        }
    }

    private int calcVNodeHashCode(int addrHashCode, int id) {
        int result = id;
        result = 31 * result + addrHashCode;
        return result;
    }
}

