/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.topology;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.CacheTopologyInfoImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.IntSets;

public class CacheInfo {
    private final String cacheName;
    private final int topologyAge;
    private final FailoverRequestBalancingStrategy balancer;
    private final int numSegments;
    private final int topologyId;
    private final List<InetSocketAddress> servers;
    private final ConsistentHash consistentHash;
    private final AtomicInteger topologyIdRef;

    public CacheInfo(WrappedBytes cacheName, FailoverRequestBalancingStrategy balancer, int topologyAge, List<InetSocketAddress> servers) {
        this.balancer = balancer;
        this.topologyAge = topologyAge;
        this.cacheName = cacheName == null || cacheName.getLength() == 0 ? "<default>" : new String(cacheName.getBytes(), HotRodConstants.HOTROD_STRING_CHARSET);
        this.numSegments = -1;
        this.topologyId = -1;
        this.consistentHash = null;
        this.servers = Immutables.immutableListCopy(servers);
        this.topologyIdRef = new AtomicInteger(this.topologyId);
    }

    public void updateBalancerServers() {
        this.balancer.setServers(this.servers);
    }

    public CacheInfo withNewServers(int topologyAge, int topologyId, List<InetSocketAddress> servers) {
        return new CacheInfo(this.cacheName, this.balancer, topologyAge, this.topologyIdRef, topologyId, servers, null, -1);
    }

    public CacheInfo withNewHash(int topologyAge, int topologyId, List<InetSocketAddress> servers, ConsistentHash consistentHash, int numSegments) {
        return new CacheInfo(this.cacheName, this.balancer, topologyAge, this.topologyIdRef, topologyId, servers, consistentHash, numSegments);
    }

    private CacheInfo(String cacheName, FailoverRequestBalancingStrategy balancer, int topologyAge, AtomicInteger topologyIdRef, int topologyId, List<InetSocketAddress> servers, ConsistentHash consistentHash, int numSegments) {
        this.balancer = balancer;
        this.topologyAge = topologyAge;
        this.cacheName = cacheName;
        this.numSegments = numSegments;
        this.topologyId = topologyId;
        this.consistentHash = consistentHash;
        this.topologyIdRef = topologyIdRef;
        this.servers = Immutables.immutableListCopy(servers);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public int getTopologyAge() {
        return this.topologyAge;
    }

    public FailoverRequestBalancingStrategy getBalancer() {
        return this.balancer;
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public AtomicInteger getTopologyIdRef() {
        return this.topologyIdRef;
    }

    public List<InetSocketAddress> getServers() {
        return this.servers;
    }

    public ConsistentHash getConsistentHash() {
        return this.consistentHash;
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        Map<SocketAddress, Set<Integer>> segmentsByServer;
        if (this.consistentHash != null) {
            segmentsByServer = this.consistentHash.getSegmentsByServer();
        } else {
            segmentsByServer = new HashMap<SocketAddress, Set<Integer>>();
            for (InetSocketAddress server : this.servers) {
                segmentsByServer.put(server, (Set<Integer>)IntSets.immutableEmptySet());
            }
        }
        return new CacheTopologyInfoImpl(segmentsByServer, this.numSegments > 0 ? Integer.valueOf(this.numSegments) : null, this.topologyId > 0 ? Integer.valueOf(this.topologyId) : null);
    }
}

