/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;

public class RestRawClientOkHttp
implements RestRawClient {
    private final RestClientOkHttp restClient;

    RestRawClientOkHttp(RestClientOkHttp restClient) {
        this.restClient = restClient;
    }

    @Override
    public CompletionStage<RestResponse> postForm(String url, Map<String, String> headers, Map<String, List<String>> formParameters) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        FormBody.Builder form = new FormBody.Builder();
        formParameters.forEach((k, vs) -> vs.forEach(v -> form.add(k, v)));
        builder.post((RequestBody)form.build());
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String url, String body, String bodyMediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        builder.post(RequestBody.create((MediaType)MediaType.parse((String)bodyMediaType), (String)body));
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        builder.post(Util.EMPTY_REQUEST);
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> putValue(String url, Map<String, String> headers, String body, String bodyMediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        builder.put(RequestBody.create((MediaType)MediaType.parse((String)bodyMediaType), (String)body));
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        builder.put(Util.EMPTY_REQUEST);
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> get(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().get().url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> delete(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        builder.delete();
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> options(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        builder.method("OPTIONS", Util.EMPTY_REQUEST);
        return this.restClient.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> head(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.restClient.getBaseURL() + url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        builder.head();
        return this.restClient.execute(builder);
    }
}

