/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Authenticator;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.http.RequestLine;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.okhttp.auth.AbstractAuthenticator;
import org.infinispan.client.rest.impl.okhttp.auth.CachingAuthenticator;

public class DigestAuthenticator
extends AbstractAuthenticator
implements CachingAuthenticator {
    private static final Pattern HEADER_REGEX = Pattern.compile("(?:\\s)([a-z]+)=(?:\"?)([\\p{Alnum}/=+]+)(?:\"?)");
    private static final String CREDENTIAL_CHARSET = "http.auth.credential-charset";
    private static final int QOP_UNKNOWN = -1;
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private AtomicReference<Map<String, String>> parametersRef = new AtomicReference();
    private Charset credentialsCharset = StandardCharsets.US_ASCII;
    private final AuthenticationConfiguration configuration;
    private String lastNonce;
    private long nounceCount;
    private String cnonce;
    private String s1;
    private String s2;

    public DigestAuthenticator(AuthenticationConfiguration configuration) {
        this.configuration = configuration;
    }

    public static String createCnonce() {
        SecureRandom rnd = new SecureRandom();
        byte[] tmp = new byte[8];
        rnd.nextBytes(tmp);
        return DigestAuthenticator.encode(tmp);
    }

    static String encode(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    public synchronized Request authenticate(Route route, Response response) throws IOException {
        String header = DigestAuthenticator.findHeader(response.headers(), "WWW-Authenticate", "Digest");
        Matcher matcher = HEADER_REGEX.matcher(header);
        HashMap<String, String> parameters = new HashMap<String, String>(8);
        while (matcher.find()) {
            parameters.put(matcher.group(1), matcher.group(2));
        }
        this.copyHeaderMap(response.headers(), parameters);
        this.parametersRef.set(Collections.unmodifiableMap(parameters));
        if (parameters.get("nonce") == null) {
            throw new IllegalArgumentException("missing nonce in challenge header: " + header);
        }
        return this.authenticateWithState(route, response.request(), parameters);
    }

    @Override
    public Request authenticateWithState(Route route, Request request) throws IOException {
        Map<String, String> ref = this.parametersRef.get();
        HashMap<String, String> parameters = ref == null ? new HashMap<String, String>() : new HashMap<String, String>(ref);
        return this.authenticateWithState(route, request, parameters);
    }

    private Request authenticateWithState(Route route, Request request, Map<String, String> parameters) throws IOException {
        String uri;
        String method;
        String realm = parameters.get("realm");
        if (realm == null) {
            return null;
        }
        String nonce = parameters.get("nonce");
        if (nonce == null) {
            throw new IllegalArgumentException("missing nonce in challenge");
        }
        String stale = parameters.get("stale");
        boolean isStale = "true".equalsIgnoreCase(stale);
        if (this.havePreviousDigestAuthorizationAndShouldAbort(request, nonce, isStale)) {
            return null;
        }
        if (route == null || !route.requiresTunnel()) {
            method = request.method();
            uri = RequestLine.requestPath((HttpUrl)request.url());
            parameters.put("methodname", method);
            parameters.put("uri", uri);
        } else {
            method = "CONNECT";
            uri = request.url().host() + ':' + request.url().port();
            parameters.put("methodname", "CONNECT");
            parameters.put("uri", uri);
        }
        String charset = parameters.get("charset");
        if (charset == null) {
            String credentialsCharset = this.getCredentialsCharset(request);
            parameters.put("charset", credentialsCharset);
        }
        return request.newBuilder().header("Authorization", this.createDigestHeader(request, parameters)).tag(Authenticator.class, (Object)this).build();
    }

    private boolean havePreviousDigestAuthorizationAndShouldAbort(Request request, String nonce, boolean isStale) {
        String headerKey = "Authorization";
        String previousAuthorizationHeader = request.header(headerKey);
        if (previousAuthorizationHeader != null && previousAuthorizationHeader.startsWith("Digest")) {
            return !isStale;
        }
        return false;
    }

    private void copyHeaderMap(Headers headers, Map<String, String> dest) {
        for (int i = 0; i < headers.size(); ++i) {
            dest.put(headers.name(i), headers.value(i));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized String createDigestHeader(Request request, Map<String, String> parameters) throws AbstractAuthenticator.AuthenticationException {
        String digestValue;
        MessageDigest digester;
        String digAlg;
        String uri = parameters.get("uri");
        String realm = parameters.get("realm");
        String nonce = parameters.get("nonce");
        String opaque = parameters.get("opaque");
        String method = parameters.get("methodname");
        String algorithm = parameters.get("algorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        HashSet<String> qopset = new HashSet<String>(8);
        int qop = -1;
        String qoplist = parameters.get("qop");
        if (qoplist != null) {
            StringTokenizer tok = new StringTokenizer(qoplist, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                qopset.add(variant.toLowerCase(Locale.US));
            }
            if (request.body() != null && qopset.contains("auth-int")) {
                qop = 1;
            } else if (qopset.contains("auth")) {
                qop = 2;
            }
        } else {
            qop = 0;
        }
        if (qop == -1) {
            throw new AbstractAuthenticator.AuthenticationException("None of the qop methods is supported: " + qoplist);
        }
        String charset = parameters.get("charset");
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1.name();
        }
        if ("MD5-sess".equalsIgnoreCase(digAlg = algorithm)) {
            digAlg = "MD5";
        }
        try {
            digester = MessageDigest.getInstance(digAlg);
        }
        catch (Exception ex) {
            throw new AbstractAuthenticator.AuthenticationException("Unsuppported digest algorithm: " + digAlg, ex);
        }
        String uname = this.configuration.username();
        String pwd = new String(this.configuration.password());
        if (nonce.equals(this.lastNonce)) {
            ++this.nounceCount;
        } else {
            this.nounceCount = 1L;
            this.cnonce = null;
            this.lastNonce = nonce;
        }
        StringBuilder sb = new StringBuilder(256);
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%08x", this.nounceCount);
        formatter.close();
        String nc = sb.toString();
        if (this.cnonce == null) {
            this.cnonce = DigestAuthenticator.createCnonce();
        }
        this.s1 = null;
        this.s2 = null;
        if ("MD5-sess".equalsIgnoreCase(algorithm)) {
            sb.setLength(0);
            sb.append(uname).append(':').append(realm).append(':').append(pwd);
            String checksum = DigestAuthenticator.encode(digester.digest(this.getBytes(sb.toString(), charset)));
            sb.setLength(0);
            sb.append(checksum).append(':').append(nonce).append(':').append(this.cnonce);
            this.s1 = sb.toString();
        } else {
            sb.setLength(0);
            sb.append(uname).append(':').append(realm).append(':').append(pwd);
            this.s1 = sb.toString();
        }
        String hasha1 = DigestAuthenticator.encode(digester.digest(this.getBytes(this.s1, charset)));
        if (qop == 2) {
            this.s2 = method + ':' + uri;
        } else if (qop == 1) {
            RequestBody entity = request.body();
            if (entity != null) {
                if (!qopset.contains("auth")) throw new AbstractAuthenticator.AuthenticationException("Qop auth-int cannot be used with a non-repeatable entity");
                qop = 2;
                this.s2 = method + ':' + uri;
            } else {
                digester.reset();
                this.s2 = method + ':' + uri + ':' + DigestAuthenticator.encode(digester.digest());
            }
        } else {
            this.s2 = method + ':' + uri;
        }
        String h2 = DigestAuthenticator.encode(digester.digest(this.getBytes(this.s2, charset)));
        if (qop == 0) {
            sb.setLength(0);
            sb.append(hasha1).append(':').append(nonce).append(':').append(h2);
            digestValue = sb.toString();
        } else {
            sb.setLength(0);
            sb.append(hasha1).append(':').append(nonce).append(':').append(nc).append(':').append(this.cnonce).append(':').append(qop == 1 ? "auth-int" : "auth").append(':').append(h2);
            digestValue = sb.toString();
        }
        String digest = DigestAuthenticator.encode(digester.digest(DigestAuthenticator.getAsciiBytes(digestValue)));
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("Digest username=\"");
        buffer.append(uname);
        buffer.append("\", realm=\"");
        buffer.append(realm);
        buffer.append("\", nonce=\"");
        buffer.append(nonce);
        buffer.append("\", uri=\"");
        buffer.append(uri);
        buffer.append("\", response=\"");
        buffer.append(digest);
        buffer.append("\", ");
        if (qop != 0) {
            buffer.append("qop=");
            buffer.append(qop == 1 ? "auth-int" : "auth");
            buffer.append(", nc=");
            buffer.append(nc);
            buffer.append(", cnonce=\"");
            buffer.append(this.cnonce);
            buffer.append("\", ");
        }
        buffer.append("algorithm=");
        buffer.append(algorithm);
        if (opaque == null) return buffer.toString();
        buffer.append(", opaque=\"");
        buffer.append(opaque);
        buffer.append('\"');
        return buffer.toString();
    }

    public Charset getCredentialsCharset() {
        return this.credentialsCharset;
    }

    String getCredentialsCharset(Request request) {
        String charset = request.header(CREDENTIAL_CHARSET);
        if (charset == null) {
            charset = this.getCredentialsCharset().name();
        }
        return charset;
    }

    private byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return data.getBytes(StandardCharsets.US_ASCII);
    }
}

