/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import okhttp3.Request;
import okhttp3.internal.Util;
import org.infinispan.client.rest.RestLoggingClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;

public class RestLoggingClientOkHttp
implements RestLoggingClient {
    private final RestClientOkHttp client;
    private final String baseLoggingURL;

    RestLoggingClientOkHttp(RestClientOkHttp restClient) {
        this.client = restClient;
        this.baseLoggingURL = String.format("%s%s/v2/logging", restClient.getBaseURL(), restClient.getConfiguration().contextPath());
    }

    @Override
    public CompletionStage<RestResponse> listLoggers() {
        return this.client.execute(this.baseLoggingURL, "loggers");
    }

    @Override
    public CompletionStage<RestResponse> listAppenders() {
        return this.client.execute(this.baseLoggingURL, "appenders");
    }

    @Override
    public CompletionStage<RestResponse> setLogger(String name, String level, String ... appenders) {
        Request.Builder builder = new Request.Builder();
        StringBuilder sb = new StringBuilder(this.baseLoggingURL);
        sb.append("/loggers/");
        if (name != null) {
            sb.append(RestClientOkHttp.sanitize(name));
        }
        sb.append("?");
        boolean amp = false;
        if (level != null) {
            sb.append("level=").append(level);
            amp = true;
        }
        if (appenders != null) {
            for (String appender : appenders) {
                if (amp) {
                    sb.append("&");
                }
                sb.append("appender=").append(appender);
                amp = true;
            }
        }
        builder.url(sb.toString()).put(Util.EMPTY_REQUEST);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> removeLogger(String name) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseLoggingURL + "/loggers/" + RestClientOkHttp.sanitize(name)).delete();
        return this.client.execute(builder);
    }
}

