/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import org.infinispan.client.rest.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.commons.configuration.Builder;

public class ServerConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ServerConfiguration> {
    private String host;
    private int port = 11222;

    ServerConfigurationBuilder(RestClientConfigurationBuilder builder) {
        super(builder);
    }

    public ServerConfigurationBuilder host(String host) {
        this.host = host;
        return this;
    }

    public ServerConfigurationBuilder port(int port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.host == null || this.host.isEmpty()) {
            throw new IllegalStateException("Missing host definition");
        }
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.host, this.port);
    }

    public ServerConfigurationBuilder read(ServerConfiguration template) {
        this.host = template.host();
        this.port = template.port();
        return this;
    }
}

