/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationProperties;
import org.infinispan.client.rest.configuration.SecurityConfiguration;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.util.TypedProperties;

@BuiltBy(value=RestClientConfigurationBuilder.class)
public class RestClientConfiguration {
    private final long connectionTimeout;
    private final List<ServerConfiguration> servers;
    private final long socketTimeout;
    private final SecurityConfiguration security;
    private final boolean tcpNoDelay;
    private final boolean tcpKeepAlive;
    private final Protocol protocol;
    private final String contextPath;
    private final boolean priorKnowledge;
    private final boolean followRedirects;
    private final Map<String, String> headers;
    private final ExecutorService executorService;
    private final boolean pingOnCreate;

    RestClientConfiguration(List<ServerConfiguration> servers, Protocol protocol, long connectionTimeout, long socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, String contextPath, boolean priorKnowledge, boolean followRedirects, boolean pingOnCreate, Map<String, String> headers, ExecutorService executorService) {
        this.servers = Collections.unmodifiableList(servers);
        this.protocol = protocol;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.contextPath = contextPath;
        this.priorKnowledge = priorKnowledge;
        this.followRedirects = followRedirects;
        this.headers = headers;
        this.executorService = executorService;
        this.pingOnCreate = pingOnCreate;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public boolean priorKnowledge() {
        return this.priorKnowledge;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public long connectionTimeout() {
        return this.connectionTimeout;
    }

    public List<ServerConfiguration> servers() {
        return this.servers;
    }

    public long socketTimeout() {
        return this.socketTimeout;
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Properties properties() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty("infinispan.client.rest.protocol", this.protocol().name());
        properties.setProperty("infinispan.client.rest.connect_timeout", Long.toString(this.connectionTimeout()));
        properties.setProperty("infinispan.client.rest.socket_timeout", this.socketTimeout());
        properties.setProperty("infinispan.client.rest.tcp_no_delay", this.tcpNoDelay());
        properties.setProperty("infinispan.client.rest.tcp_keep_alive", this.tcpKeepAlive());
        properties.setProperty("infinispan.client.rest.context_path", this.contextPath());
        properties.setProperty(RestClientConfigurationProperties.USER_AGENT, this.headers.get("User-Agent"));
        properties.setProperty("infinispan.client.rest.ping_on_create", this.pingOnCreate());
        StringBuilder servers = new StringBuilder();
        for (ServerConfiguration server : this.servers()) {
            if (!servers.isEmpty()) {
                servers.append(";");
            }
            servers.append(server.host()).append(":").append(server.port());
        }
        properties.setProperty("infinispan.client.rest.server_list", servers.toString());
        properties.setProperty("infinispan.client.rest.use_ssl", Boolean.toString(this.security.ssl().enabled()));
        if (this.security.ssl().keyStoreFileName() != null) {
            properties.setProperty("infinispan.client.rest.key_store_file_name", this.security.ssl().keyStoreFileName());
        }
        if (this.security.ssl().keyStorePassword() != null) {
            properties.setProperty("infinispan.client.rest.key_store_password", new String(this.security.ssl().keyStorePassword()));
        }
        if (this.security.ssl().trustStoreFileName() != null) {
            properties.setProperty("infinispan.client.rest.trust_store_file_name", this.security.ssl().trustStoreFileName());
        }
        if (this.security.ssl().trustStorePassword() != null) {
            properties.setProperty("infinispan.client.rest.trust_store_password", new String(this.security.ssl().trustStorePassword()));
        }
        if (this.security.ssl().sniHostName() != null) {
            properties.setProperty("infinispan.client.rest.sni_host_name", this.security.ssl().sniHostName());
        }
        if (this.security.ssl().protocol() != null) {
            properties.setProperty("infinispan.client.rest.ssl_protocol", this.security.ssl().protocol());
        }
        if (this.security.ssl().sslContext() != null) {
            properties.put((Object)"infinispan.client.rest.ssl_context", (Object)this.security.ssl().sslContext());
        }
        if (this.security.ssl().trustManagers() != null) {
            properties.put((Object)"infinispan.client.rest.trust_managers", (Object)this.security.ssl().trustManagers());
        }
        properties.setProperty("infinispan.client.rest.use_auth", Boolean.toString(this.security.authentication().enabled()));
        if (this.security.authentication().mechanism() != null) {
            properties.setProperty("infinispan.client.rest.sasl_mechanism", this.security.authentication().mechanism());
        }
        return properties;
    }

    public boolean pingOnCreate() {
        return this.pingOnCreate;
    }

    public String toURI() {
        StringBuilder sb = new StringBuilder("http");
        if (this.security.ssl().enabled()) {
            sb.append('s');
        }
        sb.append("://");
        if (this.security.authentication().enabled()) {
            sb.append(this.security.authentication().username()).append(':').append(this.security.authentication().password()).append('@');
        }
        for (int i = 0; i < this.servers.size(); ++i) {
            if (i > 0) {
                sb.append(";");
            }
            ServerConfiguration server = this.servers.get(i);
            sb.append(server.host()).append(":").append(server.port());
        }
        return sb.toString();
    }

    public String toString() {
        return "RestClientConfiguration{connectionTimeout=" + this.connectionTimeout + ", servers=" + String.valueOf(this.servers) + ", socketTimeout=" + this.socketTimeout + ", tcpNoDelay=" + this.tcpNoDelay + ", tcpKeepAlive=" + this.tcpKeepAlive + ", pingOnCreate=" + this.pingOnCreate + ", protocol=" + String.valueOf((Object)this.protocol) + ", contextPath='" + this.contextPath + "', priorKnowledge=" + this.priorKnowledge + ", followRedirects=" + this.followRedirects + ", headers=" + String.valueOf(this.headers) + ", security=" + String.valueOf(this.security) + "}";
    }
}

