/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestRaftClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.client.rest.impl.jdk.Util;

final class RestRaftClientJDK
implements RestRaftClient {
    private final RestRawClientJDK client;
    private final String path;

    RestRaftClientJDK(RestRawClientJDK client) {
        this.client = client;
        this.path = client.getConfiguration().contextPath() + "/v2/cluster/raft";
    }

    @Override
    public CompletionStage<RestResponse> addMember(String raftId) {
        return this.client.post(String.format("%s/%s", this.path, RestRaftClientJDK.validateAndSanitize(raftId)));
    }

    @Override
    public CompletionStage<RestResponse> removeMember(String raftId) {
        return this.client.delete(String.format("%s/%s", this.path, RestRaftClientJDK.validateAndSanitize(raftId)));
    }

    @Override
    public CompletionStage<RestResponse> currentMembers() {
        return this.client.get(this.path);
    }

    private static String validateAndSanitize(String raftId) {
        Objects.requireNonNull(raftId, "Raft ID must be non null");
        return Util.sanitize(raftId);
    }
}

