/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.graalvm;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmbeddedTest {
    @Test
    public void programmaticCacheTest() throws Exception {
        try (DefaultCacheManager cm = new DefaultCacheManager();){
            Cache cache = cm.createCache("local-cache", new ConfigurationBuilder().build());
            this.testCacheOperations((Cache<String, String>)cache);
        }
    }

    @Test
    public void xmlConfigTest() throws Exception {
        try (DefaultCacheManager cm = new DefaultCacheManager("embedded.xml");){
            for (String cacheName : cm.getCacheNames()) {
                Cache cache = cm.getCache(cacheName);
                this.testCacheOperations((Cache<String, String>)cache);
            }
        }
    }

    @Test
    public void clusteredCacheTest() {
        TestResourceTracker.setThreadTestName((String)"clusteredCacheTest");
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        ArrayList<EmbeddedCacheManager> cacheManagers = new ArrayList<EmbeddedCacheManager>(3);
        ArrayList<Cache> caches = new ArrayList<Cache>(3);
        for (int i = 0; i < 3; ++i) {
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)config);
            cacheManagers.add(cm);
            caches.add(cm.getCache());
        }
        TestingUtil.blockUntilViewsReceived((int)30000, caches);
        TestingUtil.waitForNoRebalance(caches);
        Cache cache = (Cache)caches.get(0);
        this.testCacheOperations((Cache<String, String>)cache);
    }

    private void testCacheOperations(Cache<String, String> cache) {
        String cacheName = cache.getName();
        String key = "1";
        cache.put((Object)key, (Object)"1");
        Assertions.assertEquals((int)1, (int)cache.size(), (String)cacheName);
        Assertions.assertEquals((Object)"1", (Object)cache.get((Object)key), (String)cacheName);
        Assertions.assertEquals((Object)"1", (Object)cache.remove((Object)key), (String)cacheName);
        Assertions.assertNull((Object)cache.get((Object)key), (String)cacheName);
    }
}

