/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.graalvm;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.infinispan.AdvancedCache;
import org.infinispan.CoreModuleImpl;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.io.xml.MXParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParserException;
import org.infinispan.commons.graalvm.Bundle;
import org.infinispan.commons.graalvm.ClassLoaderFeatureAccess;
import org.infinispan.commons.graalvm.Jandex;
import org.infinispan.commons.graalvm.ReflectionProcessor;
import org.infinispan.commons.graalvm.ReflectiveClass;
import org.infinispan.commons.graalvm.Resource;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.configuration.cache.AbstractModuleConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.marshall.exts.CollectionExternalizer;
import org.infinispan.marshall.exts.EnumExternalizer;
import org.infinispan.marshall.exts.EnumSetExternalizer;
import org.infinispan.marshall.exts.MapExternalizer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.logging.events.Messages;
import org.jboss.jandex.IndexView;
import org.jboss.logging.BasicLogger;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.LocalTransport;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.raft.AppendEntriesRequest;
import org.jgroups.protocols.raft.AppendEntriesResponse;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.perf.MPerf;
import org.jgroups.util.ThreadPool;
import org.jgroups.util.Util;

public class NativeMetadataProvider
implements org.infinispan.commons.graalvm.NativeMetadataProvider {
    static final Collection<Resource> resourceFiles = Resource.of((String[])new String[]{"META-INF/services/org\\.infinispan\\.configuration\\.parsing\\.ConfigurationParser", "META-INF/services/org\\.infinispan\\.factories\\.impl\\.ModuleMetadataBuilder", "META-INF/infinispan-version\\.properties", "org/infinispan/protostream/message-wrapping\\.proto", "protostream/common-java-types\\.proto", "protostream/common-java-container-types\\.proto", "proto/generated/user\\.commons\\.proto", "proto/generated/persistence\\.commons\\.proto", "proto/generated/persistence\\.core\\.proto", "proto/generated/global\\.commons\\.proto", "default-configs/default-jgroups-udp\\.xml", "default-configs/default-jgroups-tcp\\.xml", "default-configs/default-jgroups-kubernetes\\.xml", "default-configs/default-jgroups-ec2\\.xml", "default-configs/default-jgroups-google\\.xml", "default-configs/default-jgroups-azure\\.xml", "jg-magic-map.xml", "jg-protocol-ids.xml", "JGROUPS_VERSION.properties"});
    static final Collection<Resource> resourceRegexps = Resource.of((String[])new String[0]);
    static final Collection<Bundle> bundles = Bundle.of((String[])new String[]{"jg-messages", "java.base:sun.security.util.Resources", "com.sun.org.apache.xerces.internal.impl.msg.XMLMessages"});
    final Feature.FeatureAccess featureAccess;
    final ReflectionProcessor reflection;

    public NativeMetadataProvider() {
        this((Feature.FeatureAccess)new ClassLoaderFeatureAccess(NativeMetadataProvider.class.getClassLoader()));
    }

    public NativeMetadataProvider(Feature.FeatureAccess featureAccess) {
        this.featureAccess = featureAccess;
        this.reflection = this.reflectionProcessor();
    }

    public Stream<ReflectiveClass> reflectiveClasses() {
        return this.reflection.classes();
    }

    public Stream<Resource> includedResources() {
        return Stream.of(resourceFiles.stream(), resourceRegexps.stream()).flatMap(Function.identity());
    }

    public Stream<Bundle> bundles() {
        return bundles.stream();
    }

    private ReflectionProcessor reflectionProcessor() {
        IndexView index = Jandex.createIndex((Class[])new Class[]{Cache.class, Protocol.class, GeneratedSchema.class, CacheException.class, AdvancedCache.class});
        ReflectionProcessor reflection = new ReflectionProcessor(this.featureAccess, index);
        this.caffeine(reflection);
        this.jgroups(reflection);
        this.infinispan(reflection);
        return reflection;
    }

    private void caffeine(ReflectionProcessor processor) {
        processor.addClasses(new String[]{"com.github.benmanes.caffeine.cache.PDMS", "com.github.benmanes.caffeine.cache.PSA", "com.github.benmanes.caffeine.cache.PSMS", "com.github.benmanes.caffeine.cache.PSW", "com.github.benmanes.caffeine.cache.PSMW", "com.github.benmanes.caffeine.cache.PSAMW", "com.github.benmanes.caffeine.cache.PSAWMW", "com.github.benmanes.caffeine.cache.PSWMS", "com.github.benmanes.caffeine.cache.PSWMW", "com.github.benmanes.caffeine.cache.SILMS", "com.github.benmanes.caffeine.cache.SSA", "com.github.benmanes.caffeine.cache.SSLA", "com.github.benmanes.caffeine.cache.SSLMS", "com.github.benmanes.caffeine.cache.SSLMW", "com.github.benmanes.caffeine.cache.SSMS", "com.github.benmanes.caffeine.cache.SSMSA", "com.github.benmanes.caffeine.cache.SSMSAW", "com.github.benmanes.caffeine.cache.SSMSW", "com.github.benmanes.caffeine.cache.SSW"});
    }

    private void jgroups(ReflectionProcessor processor) {
        processor.addClasses(new Class[]{RequestCorrelator.class, MsgStats.class, AppendEntriesResponse.class, MPerf.class, Util.AddressScope.class, Version.class}).addClasses(true, true, new Class[]{MsgStats.class, AppendEntriesRequest.class, DiagnosticsHandler.class, ThreadPool.class}).addImplementations(false, false, new Class[]{PropertyConverter.class, LocalTransport.class, MessageProcessingPolicy.class}).addImplementations(true, false, new Class[]{Bundler.class, Protocol.class});
        processor.addClasses(this.jgroupsClasses().toArray(new String[0]));
    }

    private Collection<String> jgroupsClasses() {
        HashSet<String> classes = new HashSet<String>();
        try (InputStream source = Message.class.getClassLoader().getResourceAsStream("jg-magic-map.xml");){
            int eventType;
            MXParser reader = new MXParser();
            reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            reader.setInput(source, null);
            while ((eventType = reader.next()) != 1) {
                if (eventType != 2 || !reader.getName().equals("magic-number-class-mapping")) continue;
                this.parseJGroupsMagicNumbers((XmlPullParser)reader, classes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    private void parseJGroupsMagicNumbers(XmlPullParser reader, Set<String> classes) throws XmlPullParserException, IOException {
        int eventType;
        block4: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    if (reader.getName().equals("class")) {
                        String clazz = reader.getAttributeValue(null, "name");
                        classes.add(clazz);
                        reader.next();
                        continue block4;
                    }
                    throw new IOException("Unexpected content");
                }
            }
            throw new IOException("Unexpected content");
        }
        throw new IOException("Unexpected end of document");
    }

    private void infinispan(ReflectionProcessor processor) {
        processor.addClasses(new Class[]{CoreModuleImpl.class, HashFunctionPartitioner.class, CacheEntryCreated.class, CacheEntryExpired.class, CacheEntryModified.class, CacheEntryRemoved.class, JGroupsTransport.class, EmbeddedTransactionManagerLookup.class}).addImplementations(false, false, new Class[]{BasicLogger.class, AbstractExternalizer.class, AdvancedExternalizer.class, ConfigurationParser.class, AbstractModuleConfigurationBuilder.class, StoreConfigurationBuilder.class, ConfigurationSerializer.class, ConsistentHashFactory.class, ModuleMetadataBuilder.class, NonBlockingStore.class, CacheLoader.class, CacheWriter.class}).addImplementations(true, false, new Class[]{Messages.class, AsyncInterceptor.class}).addImplementation(false, true, StoreConfiguration.class).addClassesWithAnnotation(false, true, Listener.class).addClassFromAnnotationValue(false, false, SerializeWith.class).addClassFromAnnotationValue(false, false, SerializedWith.class).addClasses(new String[]{"org.infinispan.remoting.transport.jgroups.JGroupsTransport$ChannelCallbacks"}).addClasses(new String[]{"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl"});
        CollectionExternalizer.getSupportedPrivateClasses().forEach(xva$0 -> processor.addClasses(new Class[]{xva$0}));
        MapExternalizer.getSupportedPrivateClasses().forEach(xva$0 -> processor.addClasses(new Class[]{xva$0}));
        EnumExternalizer.INSTANCE.getTypeClasses().forEach(xva$0 -> processor.addClasses(new Class[]{xva$0}));
        new EnumSetExternalizer().getTypeClasses().forEach(xva$0 -> processor.addClasses(new Class[]{xva$0}));
    }
}

