/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class AddBloomNearCacheClientListenerOperation
extends ClientListenerOperation {
    private final int bloomFilterBits;
    private final RemoteCache<?, ?> remoteCache;

    protected AddBloomNearCacheClientListenerOperation(OperationContext operationContext, CacheOptions options, Object listener, DataFormat dataFormat, int bloomFilterBits, RemoteCache<?, ?> remoteCache) {
        this(operationContext, options, AddBloomNearCacheClientListenerOperation.generateListenerId(), listener, dataFormat, bloomFilterBits, remoteCache);
    }

    private AddBloomNearCacheClientListenerOperation(OperationContext operationContext, CacheOptions options, byte[] listenerId, Object listener, DataFormat dataFormat, int bloomFilterBits, RemoteCache<?, ?> remoteCache) {
        super(operationContext, (short)65, (short)66, options, listenerId, dataFormat, listener);
        this.bloomFilterBits = bloomFilterBits;
        this.remoteCache = remoteCache;
    }

    @Override
    public AddBloomNearCacheClientListenerOperation copy() {
        return new AddBloomNearCacheClientListenerOperation(this.operationContext, (CacheOptions)this.options, this.listenerId, this.listener, this.dataFormat, this.bloomFilterBits, this.remoteCache);
    }

    @Override
    protected void actualExecute(Channel channel) {
        ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registerOperation(channel, this);
        this.operationContext.getListenerNotifier().addDispatcher(ClientEventDispatcher.create(this, this.address, () -> this.cleanup(channel), this.remoteCache));
        ByteBuf buf = channel.alloc().buffer();
        Codec codec = this.operationContext.getCodec();
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.listenerId);
        codec.writeBloomFilter(buf, this.bloomFilterBits);
        channel.writeAndFlush((Object)buf);
    }
}

