/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.jboss.logging.BasicLogger;

public class PutIfAbsentOperation<K, V>
extends AbstractKeyValueOperation<K, V> {
    private static final BasicLogger log = LogFactory.getLog(PutIfAbsentOperation.class);

    public PutIfAbsentOperation(OperationContext operationContext, K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        super(operationContext, (short)5, (short)6, key, keyBytes, value, (CacheOptions)options, dataFormat);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendKeyValueOperation(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExecuted(status)) {
            Object prevValue = this.returnPossiblePrevValue(buf, status);
            if (HotRodConstants.hasPrevious(status)) {
                this.statsDataRead(true);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Returning from putIfAbsent: %s", prevValue);
            }
            this.complete(prevValue);
        } else {
            this.statsDataStore();
            this.complete(null);
        }
    }
}

