/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.protocol.Codec23;
import org.infinispan.hotrod.impl.protocol.HeaderParams;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public class Codec24
extends Codec23 {
    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)24);
    }

    @Override
    public void writeIteratorStartOperation(ByteBuf buf, IntSet segments, String filterConverterFactory, int batchSize, boolean metadata, byte[][] filterParameters) {
        if (segments == null) {
            ByteBufUtil.writeSignedVInt(buf, -1);
        } else {
            BitSet bitSet = new BitSet();
            segments.forEach(bitSet::set);
            ByteBufUtil.writeOptionalArray(buf, bitSet.toByteArray());
        }
        ByteBufUtil.writeOptionalString(buf, filterConverterFactory);
        if (filterConverterFactory != null) {
            if (filterParameters != null && filterParameters.length > 0) {
                buf.writeByte(filterParameters.length);
                Arrays.stream(filterParameters).forEach(param -> ByteBufUtil.writeArray(buf, param));
            } else {
                buf.writeByte(0);
            }
        }
        ByteBufUtil.writeVInt(buf, batchSize);
        buf.writeByte(metadata ? 1 : 0);
    }

    @Override
    public int readProjectionSize(ByteBuf buf) {
        return ByteBufUtil.readVInt(buf);
    }

    @Override
    public boolean isObjectStorageHinted(PingResponse pingResponse) {
        short status = pingResponse.getStatus();
        return status == 6 || status == 7 || status == 8;
    }
}

