/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import java.lang.reflect.Method;
import org.infinispan.api.Infinispan;
import org.infinispan.api.configuration.Configuration;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HotRodServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback {
    private HotRodServer hotRodServer;

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.stop();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.start();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Method method = (Method)extensionContext.getTestMethod().get();
        this.hotRodServer.getCacheManager().createCache(method.getName(), new ConfigurationBuilder().build());
    }

    public void start() {
        if (this.hotRodServer == null) {
            TestResourceTracker.setThreadTestName((String)"InfinispanServer");
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
            EmbeddedCacheManager ecm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().nonClusteredDefault().defaultCacheName("default"), (ConfigurationBuilder)configurationBuilder);
            ecm.administration().createTemplate("test", new ConfigurationBuilder().template(true).build());
            HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
            serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
            this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)ecm, (HotRodServerConfigurationBuilder)serverBuilder);
        }
    }

    public void stop() {
        if (this.hotRodServer != null) {
            EmbeddedCacheManager cacheManager = this.hotRodServer.getCacheManager();
            this.hotRodServer.stop();
            cacheManager.stop();
        }
    }

    public Infinispan getClient() {
        HotRodConfigurationBuilder builder = new HotRodConfigurationBuilder();
        builder.addServer().host(this.hotRodServer.getHost()).port(this.hotRodServer.getPort().intValue());
        return Infinispan.create((Configuration)builder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public HotRodServerExtension build() {
            return new HotRodServerExtension();
        }
    }
}

