/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Locale;

public final class ProtocolVersion
extends Enum<ProtocolVersion> {
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_20 = new ProtocolVersion(2, 0);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_21 = new ProtocolVersion(2, 1);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_22 = new ProtocolVersion(2, 2);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_23 = new ProtocolVersion(2, 3);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_24 = new ProtocolVersion(2, 4);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_25 = new ProtocolVersion(2, 5);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_26 = new ProtocolVersion(2, 6);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_27 = new ProtocolVersion(2, 7);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_28 = new ProtocolVersion(2, 8);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_29 = new ProtocolVersion(2, 9);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_30 = new ProtocolVersion(3, 0);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_31 = new ProtocolVersion(3, 1);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_AUTO = new ProtocolVersion(3, 1);
    private static final ProtocolVersion[] VERSIONS;
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION;
    public static final ProtocolVersion HIGHEST_PROTOCOL_VERSION;
    private final String textVersion;
    private final int version;
    private static final /* synthetic */ ProtocolVersion[] $VALUES;

    public static ProtocolVersion[] values() {
        return (ProtocolVersion[])$VALUES.clone();
    }

    public static ProtocolVersion valueOf(String name) {
        return Enum.valueOf(ProtocolVersion.class, name);
    }

    private ProtocolVersion(int major, int minor) {
        assert (minor < 10);
        this.textVersion = String.format(Locale.ROOT, "%d.%d", major, minor);
        this.version = major * 10 + minor;
    }

    public String toString() {
        return this.textVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public static ProtocolVersion parseVersion(String version) {
        for (ProtocolVersion v : VERSIONS) {
            if (!v.textVersion.equals(version)) continue;
            return v;
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    public static ProtocolVersion getBestVersion(int version) {
        for (int i = VERSIONS.length - 2; i > 0; --i) {
            if (version < ProtocolVersion.VERSIONS[i].version) continue;
            return VERSIONS[i];
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    static {
        $VALUES = new ProtocolVersion[]{PROTOCOL_VERSION_20, PROTOCOL_VERSION_21, PROTOCOL_VERSION_22, PROTOCOL_VERSION_23, PROTOCOL_VERSION_24, PROTOCOL_VERSION_25, PROTOCOL_VERSION_26, PROTOCOL_VERSION_27, PROTOCOL_VERSION_28, PROTOCOL_VERSION_29, PROTOCOL_VERSION_30, PROTOCOL_VERSION_31, PROTOCOL_VERSION_AUTO};
        VERSIONS = ProtocolVersion.values();
        DEFAULT_PROTOCOL_VERSION = PROTOCOL_VERSION_AUTO;
        HIGHEST_PROTOCOL_VERSION = VERSIONS[VERSIONS.length - 2];
    }
}

