/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.cache;

import java.lang.invoke.MethodHandles;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.impl.Util;
import org.infinispan.hotrod.impl.cache.ClientStatistics;
import org.infinispan.hotrod.impl.cache.DelegatingRemoteCache;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.cache.RemoteCacheImpl;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.AddBloomNearCacheClientListenerOperation;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.operations.RetryAwareCompletionStage;
import org.infinispan.hotrod.impl.operations.UpdateBloomFilterOperation;
import org.infinispan.hotrod.near.NearCacheService;

public class InvalidatedNearRemoteCache<K, V>
extends DelegatingRemoteCache<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final NearCacheService<K, V> nearcache;
    private final ClientStatistics clientStatistics;
    private final AtomicInteger bloomFilterUpdateVersion;
    private volatile SocketAddress listenerAddress;

    InvalidatedNearRemoteCache(RemoteCache<K, V> remoteCache, ClientStatistics clientStatistics, NearCacheService<K, V> nearcache) {
        super(remoteCache);
        this.clientStatistics = clientStatistics;
        this.nearcache = nearcache;
        this.bloomFilterUpdateVersion = nearcache.getBloomFilterBits() > 0 ? new AtomicInteger() : null;
    }

    @Override
    <Key, Value> RemoteCache<Key, Value> newDelegatingCache(RemoteCache<Key, Value> innerCache) {
        return new InvalidatedNearRemoteCache<Key, Value>(innerCache, this.clientStatistics, this.nearcache);
    }

    public static <K, V> InvalidatedNearRemoteCache<K, V> delegatingNearCache(RemoteCacheImpl<K, V> remoteCache, NearCacheService<K, V> nearCacheService) {
        return new InvalidatedNearRemoteCache<K, V>(remoteCache, remoteCache.getClientStatistics(), nearCacheService);
    }

    @Override
    public CompletionStage<V> get(K key, CacheOptions options) {
        return this.getEntry(key, options).thenApply(v -> v != null ? v.value() : null);
    }

    private int getCurrentVersion() {
        if (this.bloomFilterUpdateVersion != null) {
            return this.bloomFilterUpdateVersion.get();
        }
        return 0;
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> getEntry(K key, CacheOptions options) {
        CacheEntry<K, V> nearValue = this.nearcache.get(key);
        if (nearValue == null) {
            this.clientStatistics.incrementNearCacheMisses();
            int prevVersion = this.getCurrentVersion();
            RetryAwareCompletionStage remoteValue = super.getEntry(key, options, this.listenerAddress);
            return remoteValue.thenApply(e -> {
                if (e != null) {
                    if ((prevVersion & 1) == 1 || prevVersion != this.getCurrentVersion()) {
                        if (trace) {
                            log.tracef("Unable to cache returned value for key %s as operation was performed during a bloom filter update", new Object[0]);
                        }
                    } else if (this.listenerAddress != null && remoteValue.wasRetried().booleanValue()) {
                        if (trace) {
                            log.tracef("Unable to cache returned value for key %s as operation was retried", key);
                        }
                    } else {
                        this.nearcache.putIfAbsent((CacheEntry<K, V>)e);
                        e.metadata().expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
                    }
                }
                return e;
            });
        }
        this.clientStatistics.incrementNearCacheHits();
        return CompletableFuture.completedFuture(nearValue);
    }

    @Override
    public CompletionStage<V> put(K key, V value, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.put(key, value, options).thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletionStage<V> putIfAbsent(K key, V value, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.putIfAbsent(key, value, options).thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletionStage<Boolean> setIfAbsent(K key, V value, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.setIfAbsent(key, value, options).thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletionStage<Void> set(K key, V value, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.set(key, value, options).thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletionStage<Boolean> replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.replace(key, value, version, options).thenApply(v -> {
            if (v.booleanValue()) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.getOrReplaceEntry(key, value, version, options).thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletionStage<Boolean> remove(K key, CacheOptions options) {
        return super.remove(key, options).thenApply(v -> {
            if (v.booleanValue()) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public CompletionStage<Boolean> remove(K key, CacheEntryVersion version, CacheOptions options) {
        return super.remove(key, version, options).thenApply(v -> {
            if (v.booleanValue()) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public CompletionStage<V> getAndRemove(K key, CacheOptions options) {
        return super.getAndRemove(key, options).thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletionStage<Void> clear(CacheOptions options) {
        return super.clear(options).thenRun(this.nearcache::clear);
    }

    @Override
    public CompletionStage<Void> putAll(Map<K, V> entries, CacheWriteOptions options) {
        options.expiration().maxIdle().ifPresent(m -> Log.HOTROD.nearCacheMaxIdleUnsupported());
        return super.putAll(entries, options).thenRun(() -> entries.keySet().forEach(this.nearcache::remove));
    }

    public void start() {
        this.listenerAddress = this.nearcache.start(this);
    }

    public void stop() {
        this.nearcache.stop(this);
    }

    public void clearNearCache() {
        this.nearcache.clear();
    }

    private boolean incrementBloomVersionIfEven() {
        if (this.bloomFilterUpdateVersion != null) {
            int prev;
            do {
                if (((prev = this.bloomFilterUpdateVersion.get()) & 1) != 1) continue;
                return false;
            } while (!this.bloomFilterUpdateVersion.compareAndSet(prev, prev + 1));
        }
        return true;
    }

    CompletionStage<Void> incrementBloomVersionUponCompletion(CompletionStage<Void> stage) {
        if (this.bloomFilterUpdateVersion != null) {
            return stage.whenComplete((ignore, t) -> this.bloomFilterUpdateVersion.incrementAndGet());
        }
        return stage;
    }

    @Override
    public CompletionStage<Void> updateBloomFilter() {
        if (!this.incrementBloomVersionIfEven()) {
            if (trace) {
                log.tracef("Already have a concurrent bloom filter update for listenerId(%s) - skipping", org.infinispan.commons.util.Util.printArray((byte[])this.nearcache.getListenerId()));
            }
            return CompletableFuture.completedFuture(null);
        }
        byte[] bloomFilterBits = this.nearcache.calculateBloomBits();
        if (trace) {
            log.tracef("Sending bloom filter bits(%s) update to %s for listenerId(%s)", org.infinispan.commons.util.Util.printArray((byte[])bloomFilterBits), this.listenerAddress, org.infinispan.commons.util.Util.printArray((byte[])this.nearcache.getListenerId()));
        }
        CacheOperationsFactory cacheOperationsFactory = this.getOperationsFactory();
        UpdateBloomFilterOperation bloopOp = cacheOperationsFactory.newUpdateBloomFilterOperation(CacheOptions.DEFAULT, this.listenerAddress, bloomFilterBits);
        return this.incrementBloomVersionUponCompletion(bloopOp.execute());
    }

    public SocketAddress getBloomListenerAddress() {
        return this.listenerAddress;
    }

    public void setBloomListenerAddress(SocketAddress socketAddress) {
        this.listenerAddress = socketAddress;
    }

    @Override
    public SocketAddress addNearCacheListener(Object listener, int bloomBits) {
        AddBloomNearCacheClientListenerOperation op = this.getOperationsFactory().newAddNearCacheListenerOperation(listener, CacheOptions.DEFAULT, this.getDataFormat(), bloomBits, this);
        return (SocketAddress)Util.await(op.execute());
    }
}

