/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import java.util.Set;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.VersionedOperationResponse;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.StatsAffectingRetryingOperation;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;

public abstract class AbstractKeyOperation<K, T>
extends StatsAffectingRetryingOperation<T> {
    protected final K key;
    protected final byte[] keyBytes;

    protected AbstractKeyOperation(OperationContext operationContext, short requestCode, short responseCode, K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, requestCode, responseCode, options, dataFormat);
        this.key = key;
        this.keyBytes = keyBytes;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (retryCount == 0) {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.key == null ? this.keyBytes : (byte[])this.key, failedServers, this.operationContext.getCacheNameBytes(), this);
        } else {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(failedServers, this.operationContext.getCacheNameBytes(), this);
        }
    }

    protected T returnPossiblePrevValue(ByteBuf buf, short status) {
        return (T)this.operationContext.getCodec().returnPossiblePrevValue(buf, status, this.dataFormat, this.flags(), this.operationContext.getConfiguration().getClassAllowList(), this.operationContext.getChannelFactory().getMarshaller());
    }

    protected <V> VersionedOperationResponse<V> returnVersionedOperationResponse(ByteBuf buf, short status) {
        VersionedOperationResponse.RspCode code;
        if (HotRodConstants.isSuccess(status)) {
            code = VersionedOperationResponse.RspCode.SUCCESS;
        } else if (HotRodConstants.isNotExecuted(status)) {
            code = VersionedOperationResponse.RspCode.MODIFIED_KEY;
        } else if (HotRodConstants.isNotExist(status)) {
            code = VersionedOperationResponse.RspCode.NO_SUCH_KEY;
        } else {
            throw new IllegalStateException("Unknown response status: " + Integer.toHexString(status));
        }
        T prevValue = this.returnPossiblePrevValue(buf, status);
        return new VersionedOperationResponse<T>(prevValue, code);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append(", key=").append((Object)(this.key == null ? Util.printArray((byte[])this.keyBytes) : this.key));
    }
}

