/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.time.Duration;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.hotrod.impl.TimeUnitParam;
import org.infinispan.hotrod.impl.protocol.Codec21;
import org.infinispan.hotrod.impl.protocol.HeaderParams;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public class Codec22
extends Codec21 {
    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)22);
    }

    @Override
    public void writeExpirationParams(ByteBuf buf, CacheEntryExpiration.Impl expiration) {
        Duration maxIdle;
        byte timeUnits = TimeUnitParam.encodeTimeUnits(expiration);
        buf.writeByte((int)timeUnits);
        Duration lifespan = expiration.rawLifespan();
        if (lifespan != null && lifespan != Duration.ZERO) {
            ByteBufUtil.writeVLong(buf, lifespan.toSeconds());
        }
        if ((maxIdle = expiration.rawMaxIdle()) != null && lifespan != Duration.ZERO) {
            ByteBufUtil.writeVLong(buf, maxIdle.toSeconds());
        }
    }

    @Override
    public int estimateExpirationSize(CacheEntryExpiration.Impl expiration) {
        int lifespanSeconds = this.durationToSeconds(expiration.rawLifespan());
        int maxIdleSeconds = this.durationToSeconds(expiration.rawMaxIdle());
        return 1 + (lifespanSeconds > 0 ? ByteBufUtil.estimateVLongSize(lifespanSeconds) : 0) + (maxIdleSeconds > 0 ? ByteBufUtil.estimateVLongSize(maxIdleSeconds) : 0);
    }

    private int durationToSeconds(Duration duration) {
        return duration == null ? 0 : (int)duration.toSeconds();
    }
}

