/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.near;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.hotrod.configuration.NearCache;
import org.infinispan.hotrod.configuration.NearCacheConfiguration;

final class BoundedConcurrentMapNearCache<K, V>
implements NearCache<K, V> {
    private final ConcurrentMap<K, CacheEntry<K, V>> map;
    private final Cache<K, CacheEntry<K, V>> cache;

    private BoundedConcurrentMapNearCache(Cache<K, CacheEntry<K, V>> cache) {
        this.cache = cache;
        this.map = cache.asMap();
    }

    public static <K, V> NearCache<K, V> create(NearCacheConfiguration config, Consumer<? super CacheEntry<K, V>> removedConsumer) {
        Cache cache = Caffeine.newBuilder().maximumSize((long)config.maxEntries()).removalListener((key, value, cause) -> removedConsumer.accept(null)).build();
        return new BoundedConcurrentMapNearCache<K, V>(cache);
    }

    @Override
    public void put(CacheEntry<K, V> entry) {
        this.cache.put(entry.key(), entry);
    }

    @Override
    public void putIfAbsent(CacheEntry<K, V> entry) {
        this.map.putIfAbsent(entry.key(), entry);
    }

    @Override
    public boolean remove(K key) {
        return this.map.remove(key) != null;
    }

    @Override
    public CacheEntry<K, V> get(K key) {
        return (CacheEntry)this.map.get(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        this.cache.cleanUp();
        return this.map.size();
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        return this.map.values().stream().iterator();
    }
}

