/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.CloseableIterable;
import org.infinispan.api.common.process.CacheProcessor;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.sync.SyncCache;
import org.infinispan.api.sync.SyncCacheEntryProcessor;
import org.infinispan.api.sync.SyncQuery;
import org.infinispan.api.sync.SyncStreamingCache;
import org.infinispan.api.sync.events.cache.SyncCacheEntryListener;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.HotRodSyncContainer;
import org.infinispan.hotrod.HotRodSyncQuery;
import org.infinispan.hotrod.HotRodSyncStreamingCache;
import org.infinispan.hotrod.impl.Util;
import org.infinispan.hotrod.impl.cache.RemoteCache;

public class HotRodSyncCache<K, V>
implements SyncCache<K, V> {
    private final HotRod hotrod;
    private final RemoteCache<K, V> remoteCache;

    HotRodSyncCache(HotRod hotrod, RemoteCache<K, V> remoteCache) {
        this.hotrod = hotrod;
        this.remoteCache = remoteCache;
    }

    public String name() {
        return this.remoteCache.getName();
    }

    public CacheConfiguration configuration() {
        return Util.await(this.remoteCache.configuration());
    }

    public HotRodSyncContainer container() {
        return this.hotrod.sync();
    }

    public CacheEntry<K, V> getEntry(K key, CacheOptions options) {
        return Util.await(this.remoteCache.getEntry(key, options));
    }

    public V put(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.put(key, value, options));
    }

    public void set(K key, V value, CacheWriteOptions options) {
        Util.await(this.remoteCache.set(key, value, options));
    }

    public V putIfAbsent(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.putIfAbsent(key, value, options));
    }

    public boolean setIfAbsent(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.setIfAbsent(key, value, options));
    }

    public boolean replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Util.await(this.remoteCache.replace(key, value, version, options));
    }

    public CacheEntry<K, V> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Util.await(this.remoteCache.getOrReplaceEntry(key, value, version, options));
    }

    public boolean remove(K key, CacheOptions options) {
        return Util.await(this.remoteCache.remove(key, options));
    }

    public boolean remove(K key, CacheEntryVersion version, CacheOptions options) {
        return Util.await(this.remoteCache.remove(key, version, options));
    }

    public V getAndRemove(K key, CacheOptions options) {
        return Util.await(this.remoteCache.getAndRemove(key, options));
    }

    public CloseableIterable<K> keys() {
        throw new UnsupportedOperationException();
    }

    public CloseableIterable<K> keys(CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    public CloseableIterable<CacheEntry<K, V>> entries() {
        throw new UnsupportedOperationException();
    }

    public CloseableIterable<CacheEntry<K, V>> entries(CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<K, V> entries, CacheWriteOptions options) {
        Util.await(this.remoteCache.putAll(entries, options));
    }

    public Map<K, V> getAll(Set<K> keys) {
        throw new UnsupportedOperationException();
    }

    public Map<K, V> getAll(Set<K> keys, CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    public Map<K, V> getAll(CacheOptions options, K ... keys) {
        return null;
    }

    public Set<K> removeAll(Set<K> keys) {
        throw new UnsupportedOperationException();
    }

    public Set<K> removeAll(Set<K> keys, CacheOptions options) {
        return null;
    }

    public Map<K, V> getAndRemoveAll(Set<K> keys) {
        throw new UnsupportedOperationException();
    }

    public Map<K, V> getAndRemoveAll(Set<K> keys, CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    public long estimateSize(CacheOptions options) {
        return Util.await(this.remoteCache.estimateSize(options));
    }

    public void clear(CacheOptions options) {
        Util.await(this.remoteCache.clear(options));
    }

    public <R> SyncQuery<K, V, R> query(String query, CacheOptions options) {
        return new HotRodSyncQuery(query, options);
    }

    public AutoCloseable listen(SyncCacheEntryListener<K, V> listener) {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, T> process(Set<K> keys, SyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        throw new UnsupportedOperationException();
    }

    public <T> T processAll(CacheProcessor processor, CacheProcessorOptions options) {
        return Util.await(this.remoteCache.processAll(processor, options));
    }

    public SyncStreamingCache<K> streaming() {
        return new HotRodSyncStreamingCache<K>(this.hotrod, this.remoteCache);
    }
}

