/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter;

import java.net.SocketAddress;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.counter.operation.AddListenerOperation;
import org.infinispan.hotrod.impl.counter.operation.AddOperation;
import org.infinispan.hotrod.impl.counter.operation.CompareAndSwapOperation;
import org.infinispan.hotrod.impl.counter.operation.DefineCounterOperation;
import org.infinispan.hotrod.impl.counter.operation.GetConfigurationOperation;
import org.infinispan.hotrod.impl.counter.operation.GetCounterNamesOperation;
import org.infinispan.hotrod.impl.counter.operation.GetValueOperation;
import org.infinispan.hotrod.impl.counter.operation.IsDefinedOperation;
import org.infinispan.hotrod.impl.counter.operation.RemoveListenerOperation;
import org.infinispan.hotrod.impl.counter.operation.RemoveOperation;
import org.infinispan.hotrod.impl.counter.operation.ResetOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;

public class CounterOperationFactory {
    public static final byte[] COUNTER_CACHE_NAME = HotRodTransport.cacheNameBytes("org.infinispan.COUNTER");
    private final OperationContext operationContext;

    CounterOperationFactory(HotRodConfiguration configuration, ChannelFactory channelFactory, Codec codec) {
        this.operationContext = new OperationContext(channelFactory, codec, null, configuration, null, "org.infinispan.COUNTER");
    }

    IsDefinedOperation newIsDefinedOperation(String counterName) {
        return new IsDefinedOperation(this.operationContext, counterName);
    }

    GetConfigurationOperation newGetConfigurationOperation(String counterName) {
        return new GetConfigurationOperation(this.operationContext, counterName);
    }

    DefineCounterOperation newDefineCounterOperation(String counterName, CounterConfiguration cfg) {
        return new DefineCounterOperation(this.operationContext, counterName, cfg);
    }

    RemoveOperation newRemoveOperation(String counterName, boolean useConsistentHash) {
        return new RemoveOperation(this.operationContext, counterName, useConsistentHash);
    }

    AddOperation newAddOperation(String counterName, long delta, boolean useConsistentHash) {
        return new AddOperation(this.operationContext, counterName, delta, useConsistentHash);
    }

    GetValueOperation newGetValueOperation(String counterName, boolean useConsistentHash) {
        return new GetValueOperation(this.operationContext, counterName, useConsistentHash);
    }

    ResetOperation newResetOperation(String counterName, boolean useConsistentHash) {
        return new ResetOperation(this.operationContext, counterName, useConsistentHash);
    }

    CompareAndSwapOperation newCompareAndSwapOperation(String counterName, long expect, long update, CounterConfiguration counterConfiguration) {
        return new CompareAndSwapOperation(this.operationContext, counterName, expect, update, counterConfiguration);
    }

    GetCounterNamesOperation newGetCounterNamesOperation() {
        return new GetCounterNamesOperation(this.operationContext);
    }

    AddListenerOperation newAddListenerOperation(String counterName, byte[] listenerId, SocketAddress server) {
        return new AddListenerOperation(this.operationContext, counterName, listenerId, server);
    }

    RemoveListenerOperation newRemoveListenerOperation(String counterName, byte[] listenerId, SocketAddress server) {
        return new RemoveListenerOperation(this.operationContext, counterName, listenerId, server);
    }
}

