/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.VersionedOperationResponse;
import org.infinispan.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class RemoveIfUnmodifiedOperation<K, V>
extends AbstractKeyOperation<K, VersionedOperationResponse<V>> {
    private final long version;

    public RemoveIfUnmodifiedOperation(OperationContext operationContext, K key, byte[] keyBytes, long version, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, (short)13, (short)14, key, keyBytes, options, dataFormat.withoutValueType());
        this.version = version;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + 8);
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        buf.writeLong(this.version);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(this.returnVersionedOperationResponse(buf, status));
    }
}

