/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.SaslQop;
import org.infinispan.hotrod.configuration.SaslStrength;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.security.BasicCallbackHandler;
import org.infinispan.hotrod.impl.security.TokenCallbackHandler;
import org.infinispan.hotrod.impl.security.VoidCallbackHandler;

public class AuthenticationConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<AuthenticationConfiguration> {
    private final AttributeSet attributes = AuthenticationConfiguration.attributeDefinitionSet();
    public static final String DEFAULT_REALM = "default";
    private static final String EXTERNAL_MECH = "EXTERNAL";
    private static final String OAUTHBEARER_MECH = "OAUTHBEARER";
    private static final String GSSAPI_MECH = "GSSAPI";
    private static final String GS2_KRB5_MECH = "GS2-KRB5";
    private String username;
    private char[] password;
    private String realm;
    private String token;

    public AuthenticationConfigurationBuilder(HotRodConfigurationBuilder builder) {
        super(builder);
    }

    public AuthenticationConfigurationBuilder callbackHandler(CallbackHandler callbackHandler) {
        this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).set((Object)callbackHandler);
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthenticationConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public AuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public AuthenticationConfigurationBuilder saslMechanism(String saslMechanism) {
        this.attributes.attribute(AuthenticationConfiguration.SASL_MECHANISM).set((Object)saslMechanism);
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslProperties(Map<String, String> saslProperties) {
        this.attributes.attribute(AuthenticationConfiguration.SASL_PROPERTIES).set(saslProperties);
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslQop(SaslQop ... qop) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < qop.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(qop[i].toString());
        }
        ((Map)this.attributes.attribute(AuthenticationConfiguration.SASL_PROPERTIES).get()).put("javax.security.sasl.qop", s.toString());
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslStrength(SaslStrength ... strength) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strength.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(strength[i].toString());
        }
        ((Map)this.attributes.attribute(AuthenticationConfiguration.SASL_PROPERTIES).get()).put("javax.security.sasl.strength", s.toString());
        return this.enable();
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.attributes.attribute(AuthenticationConfiguration.SERVER_NAME).set((Object)serverName);
        return this.enable();
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.attributes.attribute(AuthenticationConfiguration.CLIENT_SUBJECT).set((Object)clientSubject);
        return this.enable();
    }

    public AuthenticationConfigurationBuilder username(String username) {
        this.username = username;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(String password) {
        this.password = password != null ? password.toCharArray() : null;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(char[] password) {
        this.password = password;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder realm(String realm) {
        this.realm = realm;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder token(String token) {
        this.token = token;
        return this.enable();
    }

    public AuthenticationConfiguration create() {
        String mech = (String)this.attributes.attribute(AuthenticationConfiguration.SASL_MECHANISM).get();
        CallbackHandler cbh = (CallbackHandler)this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).get();
        if (cbh == null) {
            if (OAUTHBEARER_MECH.equals(mech)) {
                this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).set((Object)new TokenCallbackHandler(this.token));
            } else if (this.username != null) {
                this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).set((Object)new BasicCallbackHandler(this.username, this.realm != null ? this.realm : DEFAULT_REALM, this.password));
            } else if (EXTERNAL_MECH.equals(mech) || GSSAPI_MECH.equals(mech) || GS2_KRB5_MECH.equals(mech)) {
                this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).set((Object)new VoidCallbackHandler());
            }
        }
        return new AuthenticationConfiguration(this.attributes.protect());
    }

    public AuthenticationConfigurationBuilder read(AuthenticationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(AuthenticationConfiguration.ENABLED).get()).booleanValue()) {
            Attribute cbh = this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER);
            Attribute mech = this.attributes.attribute(AuthenticationConfiguration.SASL_MECHANISM);
            if (cbh.isNull() && this.attributes.attribute(AuthenticationConfiguration.CLIENT_SUBJECT).isNull() && this.username == null && this.token == null && !EXTERNAL_MECH.equals(mech)) {
                throw Log.HOTROD.invalidAuthenticationConfiguration();
            }
            if (OAUTHBEARER_MECH.equals(mech) && cbh.isNull() && this.token == null) {
                throw Log.HOTROD.oauthBearerWithoutToken();
            }
            if (!(cbh.isNull() || this.username == null && this.token == null)) {
                throw Log.HOTROD.callbackHandlerAndUsernameMutuallyExclusive();
            }
        }
    }

    @Override
    public HotRodConfigurationBuilder withProperties(Properties properties) {
        this.attributes.fromProperties(TypedProperties.toTypedProperties((Map)properties), "org.infinispan.client.");
        return this.builder;
    }
}

