/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.EnumSet;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.hotrod.event.ClientListener;
import org.infinispan.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class AddClientListenerOperation
extends ClientListenerOperation {
    private final byte[][] filterFactoryParams;
    private final byte[][] converterFactoryParams;
    private final RemoteCache<?, ?> remoteCache;

    protected AddClientListenerOperation(OperationContext operationContext, CacheOptions options, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat, RemoteCache<?, ?> remoteCache) {
        this(operationContext, options, AddClientListenerOperation.generateListenerId(), listener, filterFactoryParams, converterFactoryParams, dataFormat, remoteCache);
    }

    private AddClientListenerOperation(OperationContext operationContext, CacheOptions options, byte[] listenerId, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat, RemoteCache<?, ?> remoteCache) {
        super(operationContext, (short)37, (short)38, options, listenerId, dataFormat, listener);
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
        this.remoteCache = remoteCache;
    }

    @Override
    public AddClientListenerOperation copy() {
        return new AddClientListenerOperation(this.operationContext, (CacheOptions)this.options, this.listenerId, this.listener, this.filterFactoryParams, this.converterFactoryParams, this.dataFormat, this.remoteCache);
    }

    @Override
    protected void actualExecute(Channel channel) {
        ClientListener clientListener = null;
        ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registerOperation(channel, this);
        this.operationContext.getListenerNotifier().addDispatcher(ClientEventDispatcher.create(this, this.address, () -> this.cleanup(channel), this.remoteCache));
        ByteBuf buf = channel.alloc().buffer();
        Codec codec = this.operationContext.getCodec();
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.listenerId);
        codec.writeClientListenerParams(buf, clientListener, this.filterFactoryParams, this.converterFactoryParams);
        codec.writeClientListenerInterests(buf, EnumSet.noneOf(CacheEntryEventType.class));
        channel.writeAndFlush((Object)buf);
    }
}

