/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.StatsAffectingRetryingOperation;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class GetAllOperation<K, V>
extends StatsAffectingRetryingOperation<Map<K, V>> {
    protected final Set<byte[]> keys;
    private Map<K, V> result;
    private int size = -1;

    public GetAllOperation(OperationContext operationContext, Set<byte[]> keys, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, (short)47, (short)48, options, dataFormat);
        this.keys = keys;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        int bufSize = this.operationContext.getCodec().estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(this.keys.size());
        for (byte[] key : this.keys) {
            bufSize += ByteBufUtil.estimateArraySize(key);
        }
        ByteBuf buf = channel.alloc().buffer(bufSize);
        this.operationContext.getCodec().writeHeader(buf, this.header);
        ByteBufUtil.writeVInt(buf, this.keys.size());
        for (byte[] key : this.keys) {
            ByteBufUtil.writeArray(buf, key);
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result = null;
        this.size = -1;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.keys.iterator().next(), failedServers, this.operationContext.getCacheNameBytes(), this);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.size < 0) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = new HashMap(this.size);
            decoder.checkpoint();
        }
        while (this.result.size() < this.size) {
            Object key = this.dataFormat.keyToObj(ByteBufUtil.readArray(buf), this.operationContext.getConfiguration().getClassAllowList());
            Object value = this.dataFormat.valueToObj(ByteBufUtil.readArray(buf), this.operationContext.getConfiguration().getClassAllowList());
            this.result.put(key, value);
            decoder.checkpoint();
        }
        this.statsDataRead(true, this.size);
        this.statsDataRead(false, this.keys.size() - this.size);
        this.complete(this.result);
    }
}

