/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.HotRodFlag;
import org.infinispan.hotrod.HotRodFlags;
import org.infinispan.hotrod.exceptions.HotRodClientException;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.HeaderParams;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public abstract class HotRodOperation<T>
extends CompletableFuture<T>
implements HotRodConstants,
Runnable {
    private static final Log log = LogFactory.getLog(HotRodOperation.class);
    private static final AtomicLong MSG_ID = new AtomicLong(1L);
    private static final byte NO_TX = 0;
    protected final OperationContext operationContext;
    protected final CacheOptions.Impl options;
    protected final DataFormat dataFormat;
    protected final HeaderParams header;
    protected volatile ScheduledFuture<?> timeoutFuture;
    private Channel channel;

    protected HotRodOperation(OperationContext operationContext, short requestCode, short responseCode, CacheOptions options, DataFormat dataFormat) {
        this.operationContext = operationContext;
        this.options = (CacheOptions.Impl)options;
        this.dataFormat = dataFormat;
        this.header = new HeaderParams(requestCode, responseCode, MSG_ID.getAndIncrement()).cacheName(operationContext.getCacheNameBytes()).flags(this.flags()).clientIntel(operationContext.getConfiguration().clientIntelligence()).topologyId(operationContext.getTopologyId()).txMarker((byte)0).dataFormat(dataFormat).topologyAge(operationContext.getChannelFactory().getTopologyAge());
    }

    protected HotRodOperation(OperationContext operationContext, short requestCode, short responseCode, CacheOptions options) {
        this(operationContext, requestCode, responseCode, options, null);
    }

    public abstract CompletionStage<T> execute();

    public HeaderParams header() {
        return this.header;
    }

    protected int flags() {
        int flags = HotRodFlags.toInt(this.options);
        if (this.options instanceof CacheWriteOptions) {
            CacheEntryExpiration.Impl expiration = (CacheEntryExpiration.Impl)((CacheWriteOptions)this.options).expiration();
            if (expiration.rawLifespan() == null) {
                flags |= HotRodFlag.DEFAULT_LIFESPAN.getFlagInt();
            }
            if (expiration.rawMaxIdle() == null) {
                flags |= HotRodFlag.DEFAULT_MAXIDLE.getFlagInt();
            }
        }
        return flags;
    }

    protected void sendHeaderAndRead(Channel channel) {
        this.scheduleRead(channel);
        this.sendHeader(channel);
    }

    protected void sendHeader(Channel channel) {
        ByteBuf buf = channel.alloc().buffer(this.operationContext.getCodec().estimateHeaderSize(this.header));
        this.operationContext.getCodec().writeHeader(buf, this.header);
        channel.writeAndFlush((Object)buf);
    }

    protected void scheduleRead(Channel channel) {
        ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registerOperation(channel, this);
    }

    public void releaseChannel(Channel channel) {
        this.operationContext.getChannelFactory().releaseChannel(channel);
    }

    public void channelInactive(Channel channel) {
        SocketAddress address = channel.remoteAddress();
        this.completeExceptionally(log.connectionClosed(address, address));
    }

    public void exceptionCaught(Channel channel, Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        try {
            if (cause instanceof HotRodClientException && ((HotRodClientException)cause).isServerError()) {
            } else {
                Log.HOTROD.closingChannelAfterError(channel, cause);
                channel.close();
            }
        }
        finally {
            this.completeExceptionally(cause);
        }
    }

    protected void sendArrayOperation(Channel channel, byte[] array) {
        ByteBuf buf = channel.alloc().buffer(this.operationContext.getCodec().estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(array));
        this.operationContext.getCodec().writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, array);
        channel.writeAndFlush((Object)buf);
    }

    public abstract void acceptResponse(ByteBuf var1, short var2, HeaderDecoder var3);

    @Override
    public String toString() {
        byte[] cacheName = this.operationContext.getCacheNameBytes();
        String cn = cacheName == null || cacheName.length == 0 ? "(default)" : new String(cacheName);
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('{').append(cn);
        this.addParams(sb);
        sb.append(", flags=").append(Integer.toHexString(this.flags()));
        if (this.channel != null) {
            sb.append(", connection=").append(this.channel.remoteAddress());
        }
        sb.append('}');
        return sb.toString();
    }

    protected void addParams(StringBuilder sb) {
    }

    @Override
    public boolean complete(T value) {
        this.cancelTimeout();
        return super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.cancelTimeout();
        return super.completeExceptionally(ex);
    }

    public void scheduleTimeout(Channel channel) {
        assert (this.timeoutFuture == null);
        this.channel = channel;
        this.timeoutFuture = channel.eventLoop().schedule((Runnable)this, (long)this.operationContext.getChannelFactory().socketTimeout(), TimeUnit.MILLISECONDS);
    }

    private void cancelTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }

    @Override
    public void run() {
        this.exceptionCaught(this.channel, new SocketTimeoutException(this + " timed out after " + this.operationContext.getChannelFactory().socketTimeout() + " ms"));
    }
}

