/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.util.IntSet;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class IterationStartOperation
extends RetryOnFailureOperation<IterationStartResponse> {
    private final String filterConverterFactory;
    private final byte[][] filterParameters;
    private final IntSet segments;
    private final int batchSize;
    private final boolean metadata;
    private final SocketAddress addressTarget;
    private Channel channel;

    IterationStartOperation(OperationContext operationContext, CacheOptions options, String filterConverterFactory, byte[][] filterParameters, IntSet segments, int batchSize, boolean metadata, DataFormat dataFormat, SocketAddress addressTarget) {
        super(operationContext, (short)49, (short)50, options, dataFormat);
        this.filterConverterFactory = filterConverterFactory;
        this.filterParameters = filterParameters;
        this.segments = segments;
        this.batchSize = batchSize;
        this.metadata = metadata;
        this.addressTarget = addressTarget;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.channel = channel;
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer();
        this.operationContext.getCodec().writeHeader(buf, this.header);
        this.operationContext.getCodec().writeIteratorStartOperation(buf, this.segments, this.filterConverterFactory, this.batchSize, this.metadata, this.filterParameters);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.addressTarget != null) {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.addressTarget, this);
        } else {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        }
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        SegmentConsistentHash consistentHash = (SegmentConsistentHash)this.operationContext.getChannelFactory().getConsistentHash(this.operationContext.getCacheNameBytes());
        IterationStartResponse response = new IterationStartResponse(ByteBufUtil.readArray(buf), consistentHash, this.header.topologyId().get(), this.channel);
        this.complete(response);
    }
}

