/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.cache.ClientStatistics;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.hotrod.telemetry.impl.TelemetryService;

public class OperationContext {
    private final ChannelFactory channelFactory;
    private final AtomicInteger topologyId;
    private final ClientListenerNotifier listenerNotifier;
    private final HotRodConfiguration configuration;
    private final ClientStatistics clientStatistics;
    private final TelemetryService telemetryService;
    private final byte[] cacheNameBytes;
    private final String cacheName;
    private Codec codec;

    public OperationContext(ChannelFactory channelFactory, Codec codec, ClientListenerNotifier listenerNotifier, HotRodConfiguration configuration, ClientStatistics clientStatistics, TelemetryService telemetryService, String cacheName) {
        this.channelFactory = channelFactory;
        this.codec = codec;
        this.listenerNotifier = listenerNotifier;
        this.configuration = configuration;
        this.clientStatistics = clientStatistics;
        this.telemetryService = telemetryService;
        this.cacheName = cacheName;
        this.cacheNameBytes = cacheName == null ? HotRodConstants.DEFAULT_CACHE_NAME_BYTES : HotRodTransport.cacheNameBytes(cacheName);
        this.topologyId = channelFactory != null ? channelFactory.createTopologyId(this.cacheNameBytes) : new AtomicInteger(-1);
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public AtomicInteger getTopologyId() {
        return this.topologyId;
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    public HotRodConfiguration getConfiguration() {
        return this.configuration;
    }

    public ClientStatistics getClientStatistics() {
        return this.clientStatistics;
    }

    public TelemetryService getTelemetryService() {
        return this.telemetryService;
    }

    public byte[] getCacheNameBytes() {
        return this.cacheNameBytes;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }
}

