/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.topology;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.util.Immutables;

public class ClusterInfo {
    private final String clusterName;
    private final List<InetSocketAddress> servers;
    private final int topologyAge;
    private final CompletableFuture<ClusterInfo> clusterSwitchFuture = new CompletableFuture();

    public ClusterInfo(String clusterName, List<InetSocketAddress> servers) {
        this(clusterName, servers, -1);
    }

    private ClusterInfo(String clusterName, List<InetSocketAddress> servers, int topologyAge) {
        this.clusterName = clusterName;
        this.servers = Immutables.immutableListCopy(servers);
        this.topologyAge = topologyAge;
    }

    public ClusterInfo withTopologyAge(int topologyAge) {
        return new ClusterInfo(this.clusterName, this.servers, topologyAge);
    }

    public String getName() {
        return this.clusterName;
    }

    public List<InetSocketAddress> getInitialServers() {
        return this.servers;
    }

    public int getTopologyAge() {
        return this.topologyAge;
    }

    public CompletableFuture<ClusterInfo> getClusterSwitchFuture() {
        return this.clusterSwitchFuture;
    }

    public String toString() {
        return "ClusterInfo{name='" + this.clusterName + "', servers=" + this.servers + ", age=" + this.topologyAge + "}";
    }
}

