/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.ClusterConfiguration;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.ServerConfiguration;
import org.infinispan.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.hotrod.impl.logging.Log;

public class ClusterConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ClusterConfiguration> {
    private final List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private final AttributeSet attributes = ClusterConfiguration.attributeDefinitionSet();

    protected ClusterConfigurationBuilder(HotRodConfigurationBuilder builder, String clusterName) {
        super(builder);
        this.attributes.attribute(ClusterConfiguration.NAME).set((Object)clusterName);
    }

    public String getClusterName() {
        return (String)this.attributes.attribute(ClusterConfiguration.NAME).get();
    }

    public ClusterConfigurationBuilder addClusterNode(String host, int port) {
        ServerConfigurationBuilder serverBuilder = new ServerConfigurationBuilder(this.builder);
        this.servers.add(serverBuilder.host(host).port(port));
        return this;
    }

    public ClusterConfigurationBuilder addClusterNodes(String serverList) {
        HotRodConfigurationBuilder.parseServers(serverList, (host, port) -> {
            ServerConfigurationBuilder serverBuilder = new ServerConfigurationBuilder(this.builder);
            this.servers.add(serverBuilder.host((String)host).port((int)port));
        });
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(ClusterConfiguration.NAME).isNull()) {
            throw Log.HOTROD.missingClusterNameDefinition();
        }
        if (this.servers.isEmpty()) {
            throw Log.HOTROD.missingClusterServersDefinition(this.getClusterName());
        }
        for (ServerConfigurationBuilder serverConfigBuilder : this.servers) {
            serverConfigBuilder.validate();
        }
    }

    public ClusterConfiguration create() {
        List<ServerConfiguration> serverCluster = this.servers.stream().map(ServerConfigurationBuilder::create).collect(Collectors.toList());
        return new ClusterConfiguration(this.attributes, serverCluster);
    }

    public Builder<?> read(ClusterConfiguration template) {
        template.getServers().forEach(server -> this.addClusterNode(server.host(), server.port()));
        return this;
    }
}

