/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.configuration.ClientIntelligence;
import org.infinispan.hotrod.configuration.ClusterConfiguration;
import org.infinispan.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.hotrod.configuration.ConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.hotrod.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.hotrod.configuration.FailoverRequestBalancingStrategy;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.configuration.ProtocolVersion;
import org.infinispan.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.hotrod.configuration.ServerConfiguration;
import org.infinispan.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.hotrod.configuration.StatisticsConfigurationBuilder;
import org.infinispan.hotrod.configuration.TransportFactory;
import org.infinispan.hotrod.impl.HotRodURI;
import org.infinispan.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.protostream.SerializationContextInitializer;

public class HotRodConfigurationBuilder
implements ConfigurationChildBuilder,
Builder<HotRodConfiguration> {
    private static final Log log = LogFactory.getLog(HotRodConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = HotRodConfiguration.attributeDefinitionSet();
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\[([0-9A-Fa-f:]+)\\]|([^:/?#]*))(?::(\\d*))?");
    private static final int CACHE_PREFIX_LENGTH = "infinispan.client.hotrod.cache.".length();
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory = RoundRobinBalancingStrategy::new;
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private final List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private final SecurityConfigurationBuilder security;
    private final List<String> allowListRegExs = new ArrayList<String>();
    private final StatisticsConfigurationBuilder statistics;
    private final List<ClusterConfigurationBuilder> clusters = new ArrayList<ClusterConfigurationBuilder>();
    private Features features;
    private final List<SerializationContextInitializer> contextInitializers = new ArrayList<SerializationContextInitializer>();
    private final Map<String, RemoteCacheConfigurationBuilder> remoteCacheBuilders;
    private TransportFactory transportFactory = TransportFactory.DEFAULT;
    private boolean tracingPropagationEnabled = true;

    public HotRodConfigurationBuilder() {
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
        this.statistics = new StatisticsConfigurationBuilder(this);
        this.remoteCacheBuilders = new HashMap<String, RemoteCacheConfigurationBuilder>();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public ServerConfigurationBuilder addServer() {
        ServerConfigurationBuilder builder = new ServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    @Override
    public ClusterConfigurationBuilder addCluster(String clusterName) {
        ClusterConfigurationBuilder builder = new ClusterConfigurationBuilder(this, clusterName);
        this.clusters.add(builder);
        return builder;
    }

    @Override
    public HotRodConfigurationBuilder addServers(String servers) {
        HotRodConfigurationBuilder.parseServers(servers, (host, port) -> this.addServer().host((String)host).port((int)port));
        return this;
    }

    public List<ServerConfigurationBuilder> servers() {
        return this.servers;
    }

    public static void parseServers(String servers, BiConsumer<String, Integer> c) {
        for (String server : servers.split(";")) {
            Matcher matcher = ADDRESS_PATTERN.matcher(server.trim());
            if (!matcher.matches()) {
                throw Log.HOTROD.parseErrorServerAddress(server);
            }
            String v6host = matcher.group(2);
            String v4host = matcher.group(3);
            String host = v6host != null ? v6host : v4host;
            String portString = matcher.group(4);
            int port = portString == null ? 11222 : Integer.parseInt(portString);
            c.accept(host, port);
        }
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public HotRodConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.balancingStrategyFactory = () -> (FailoverRequestBalancingStrategy)Util.getInstance((String)balancingStrategy, (ClassLoader)HotRod.class.getClassLoader());
        return this;
    }

    @Override
    public HotRodConfigurationBuilder balancingStrategy(Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory) {
        this.balancingStrategyFactory = balancingStrategyFactory;
        return this;
    }

    @Override
    public HotRodConfigurationBuilder balancingStrategy(Class<? extends FailoverRequestBalancingStrategy> balancingStrategy) {
        this.balancingStrategyFactory = () -> (FailoverRequestBalancingStrategy)Util.getInstance((Class)balancingStrategy);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder clientIntelligence(ClientIntelligence clientIntelligence) {
        this.attributes.attribute(HotRodConfiguration.CLIENT_INTELLIGENCE).set((Object)clientIntelligence);
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public HotRodConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.attributes.attribute(HotRodConfiguration.CONNECT_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder consistentHashImpl(int version, Class<? extends ConsistentHash> consistentHashClass) {
        if (version == 1) {
            log.warn("Hash function version 1 is no longer supported.");
        } else {
            ((Class[])this.attributes.attribute(HotRodConfiguration.CONSISTENT_HASH_IMPL).get())[version - 1] = consistentHashClass;
        }
        return this;
    }

    @Override
    public HotRodConfigurationBuilder consistentHashImpl(int version, String consistentHashClass) {
        return this.consistentHashImpl(version, Util.loadClass((String)consistentHashClass, (ClassLoader)HotRod.class.getClassLoader()));
    }

    @Override
    public HotRodConfigurationBuilder dnsResolverMinTTL(int ttl) {
        this.attributes.attribute(HotRodConfiguration.DNS_RESOLVER_MIN_TTL).set((Object)ttl);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder dnsResolverMaxTTL(int ttl) {
        this.attributes.attribute(HotRodConfiguration.DNS_RESOLVER_MAX_TTL).set((Object)ttl);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder dnsResolverNegativeTTL(int ttl) {
        this.attributes.attribute(HotRodConfiguration.DNS_RESOLVER_NEGATIVE_TTL).set((Object)ttl);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(HotRodConfiguration.FORCE_RETURN_VALUES).set((Object)forceReturnValues);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder marshaller(String marshallerClassName) {
        return this.marshaller(marshallerClassName == null ? null : Util.loadClass((String)marshallerClassName, (ClassLoader)HotRod.class.getClassLoader()));
    }

    @Override
    public HotRodConfigurationBuilder marshaller(Class<? extends Marshaller> marshallerClass) {
        this.attributes.attribute(HotRodConfiguration.MARSHALLER).set(marshallerClass == null ? null : (Marshaller)Util.getInstance(marshallerClass));
        this.attributes.attribute(HotRodConfiguration.MARSHALLER_CLASS).set(marshallerClass);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder marshaller(Marshaller marshaller) {
        this.attributes.attribute(HotRodConfiguration.MARSHALLER).set((Object)marshaller);
        this.attributes.attribute(HotRodConfiguration.MARSHALLER_CLASS).set(marshaller == null ? null : marshaller.getClass());
        return this;
    }

    @Override
    public HotRodConfigurationBuilder addContextInitializer(String contextInitializer) {
        SerializationContextInitializer sci = (SerializationContextInitializer)Util.getInstance((String)contextInitializer, (ClassLoader)HotRod.class.getClassLoader());
        return this.addContextInitializers(sci);
    }

    @Override
    public HotRodConfigurationBuilder addContextInitializer(SerializationContextInitializer contextInitializer) {
        if (contextInitializer != null) {
            this.contextInitializers.add(contextInitializer);
        }
        return this;
    }

    @Override
    public HotRodConfigurationBuilder addContextInitializers(SerializationContextInitializer ... contextInitializers) {
        this.contextInitializers.addAll(Arrays.asList(contextInitializers));
        return this;
    }

    @Override
    public HotRodConfigurationBuilder version(ProtocolVersion protocolVersion) {
        this.attributes.attribute(HotRodConfiguration.VERSION).set((Object)protocolVersion);
        return this;
    }

    @Override
    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public HotRodConfigurationBuilder socketTimeout(int socketTimeout) {
        this.attributes.attribute(HotRodConfiguration.SOCKET_TIMEOUT).set((Object)socketTimeout);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.attributes.attribute(HotRodConfiguration.TCP_NODELAY).set((Object)tcpNoDelay);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder tcpKeepAlive(boolean keepAlive) {
        this.attributes.attribute(HotRodConfiguration.TCP_KEEPALIVE).set((Object)keepAlive);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder uri(URI uri) {
        return HotRodURI.create(uri).toConfigurationBuilder(this);
    }

    @Override
    public HotRodConfigurationBuilder uri(String uri) {
        return this.uri(URI.create(uri));
    }

    @Override
    public HotRodConfigurationBuilder maxRetries(int maxRetries) {
        this.attributes.attribute(HotRodConfiguration.MAX_RETRIES).set((Object)maxRetries);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder addJavaSerialAllowList(String ... regEx) {
        this.allowListRegExs.addAll(Arrays.asList(regEx));
        return this;
    }

    @Override
    public HotRodConfigurationBuilder batchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        this.attributes.attribute(HotRodConfiguration.BATCH_SIZE).set((Object)batchSize);
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder statistics() {
        return this.statistics;
    }

    @Override
    public RemoteCacheConfigurationBuilder remoteCache(String name) {
        return this.remoteCacheBuilders.computeIfAbsent(name, n -> new RemoteCacheConfigurationBuilder(this, (String)n));
    }

    @Override
    public HotRodConfigurationBuilder transactionTimeout(long timeout, TimeUnit timeUnit) {
        this.attributes.attribute(HotRodConfiguration.TRANSACTION_TIMEOUT).set((Object)timeUnit.toMillis(timeout));
        return this;
    }

    @Override
    public HotRodConfigurationBuilder transportFactory(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
        return this;
    }

    public HotRodConfigurationBuilder disableTracingPropagation() {
        this.tracingPropagationEnabled = false;
        return this;
    }

    @Override
    public HotRodConfigurationBuilder withProperties(Properties properties) {
        return this;
    }

    public void validate() {
        this.attributes.validate();
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        this.security.validate();
        this.statistics.validate();
        if ((Integer)this.attributes.attribute(HotRodConfiguration.MAX_RETRIES).get() < 0) {
            throw Log.HOTROD.invalidMaxRetries((Integer)this.attributes.attribute(HotRodConfiguration.MAX_RETRIES).get());
        }
        HashSet<String> clusterNameSet = new HashSet<String>(this.clusters.size());
        for (ClusterConfigurationBuilder clusterConfigBuilder : this.clusters) {
            if (!clusterNameSet.add(clusterConfigBuilder.getClusterName())) {
                throw Log.HOTROD.duplicateClusterDefinition(clusterConfigBuilder.getClusterName());
            }
            clusterConfigBuilder.validate();
        }
    }

    public HotRodConfiguration create() {
        ArrayList<ServerConfiguration> servers = new ArrayList<ServerConfiguration>();
        if (this.servers.size() > 0) {
            for (ServerConfigurationBuilder server : this.servers) {
                servers.add(server.create());
            }
        } else {
            servers.add(new ServerConfiguration(ServerConfiguration.attributeDefinitionSet().protect()));
        }
        List<ClusterConfiguration> serverClusterConfigs = this.clusters.stream().map(ClusterConfigurationBuilder::create).collect(Collectors.toList());
        Map<String, RemoteCacheConfiguration> remoteCaches = this.remoteCacheBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RemoteCacheConfigurationBuilder)e.getValue()).create()));
        return new HotRodConfiguration(this.attributes.protect(), this.asyncExecutorFactory.create(), this.balancingStrategyFactory, this.connectionPool.create(), servers, this.security.create(), serverClusterConfigs, this.statistics.create(), this.features, this.contextInitializers, remoteCaches, this.transportFactory, this.tracingPropagationEnabled);
    }

    private Marshaller handleNullMarshaller() {
        return new ProtoStreamMarshaller();
    }

    @Override
    public HotRodConfiguration build() {
        this.features = new Features(HotRod.class.getClassLoader());
        return this.build(true);
    }

    public HotRodConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public HotRodConfigurationBuilder read(HotRodConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.asyncExecutorFactory.read(template.asyncExecutorFactory(), combine);
        this.balancingStrategyFactory = template.balancingStrategyFactory();
        this.connectionPool.read(template.connectionPool(), combine);
        this.servers.clear();
        for (ServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.clusters.clear();
        template.clusters().forEach(cluster -> this.addCluster(cluster.getClusterName()).read((ClusterConfiguration)((Object)cluster), combine));
        this.security.read(template.security(), combine);
        this.transportFactory = template.transportFactory();
        this.statistics.read(template.statistics(), combine);
        this.contextInitializers.clear();
        this.contextInitializers.addAll(template.getContextInitializers());
        return this;
    }

    public HotRodConfigurationBuilder read(HotRodConfiguration template) {
        return this.read(template, Combine.DEFAULT);
    }
}

