/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.cache.VersionedMetadataImpl;
import org.infinispan.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.ChannelInputStream;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class GetStreamOperation<K>
extends AbstractKeyOperation<K, ChannelInputStream> {
    private final int offset;
    private Channel channel;

    public GetStreamOperation(OperationContext operationContext, K key, byte[] keyBytes, int offset, CacheOptions options) {
        super(operationContext, (short)55, (short)56, key, keyBytes, options, null);
        this.offset = offset;
    }

    @Override
    public void executeOperation(Channel channel) {
        this.channel = channel;
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.operationContext.getCodec().estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + ByteBufUtil.estimateVIntSize(this.offset));
        this.operationContext.getCodec().writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        ByteBufUtil.writeVInt(buf, this.offset);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status) || !HotRodConstants.isSuccess(status)) {
            this.statsDataRead(false);
            this.complete(null);
        } else {
            int totalLength;
            long version;
            VersionedMetadataImpl versionedMetadata;
            ChannelInputStream stream;
            short flags = buf.readUnsignedByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = buf.readLong();
                lifespan = ByteBufUtil.readVInt(buf);
            }
            if ((flags & 2) != 2) {
                lastUsed = buf.readLong();
                maxIdle = ByteBufUtil.readVInt(buf);
            }
            if ((stream = new ChannelInputStream(versionedMetadata = new VersionedMetadataImpl(creation, lifespan, lastUsed, maxIdle, version = buf.readLong()), () -> {
                if (this.channel.pipeline().get(ChannelInputStream.class) != null) {
                    this.channel.pipeline().remove(ChannelInputStream.class);
                }
            }, totalLength = ByteBufUtil.readVInt(buf))).moveReadable(buf)) {
                this.channel.pipeline().addBefore("header-decoder", "stream", (ChannelHandler)stream);
            }
            this.statsDataRead(true);
            this.complete(stream);
        }
    }
}

