/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.hotrod.configuration.TransactionMode;
import org.infinispan.hotrod.transaction.lookup.GenericTransactionManagerLookup;

public class RemoteCacheConfiguration
extends ConfigurationElement<RemoteCacheConfiguration> {
    public static final AttributeDefinition<String> CONFIGURATION = AttributeDefinition.builder((String)"configuration", null, String.class).build();
    public static final AttributeDefinition<Boolean> FORCE_RETURN_VALUES = AttributeDefinition.builder((String)"force-return-values", (Object)false, Boolean.class).build();
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    public static final AttributeDefinition<String> TEMPLATE_NAME = AttributeDefinition.builder((String)"template-name", null, String.class).build();
    public static final AttributeDefinition<TransactionMode> TRANSACTION_MODE = AttributeDefinition.builder((String)"transaction-mode", (Object)((Object)TransactionMode.NONE)).build();
    public static final AttributeDefinition<TransactionManagerLookup> TRANSACTION_MANAGER = AttributeDefinition.builder((String)"transaction-manager", (Object)GenericTransactionManagerLookup.getInstance(), TransactionManagerLookup.class).build();
    public static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder((String)"marshaller", null, Marshaller.class).build();
    public static final AttributeDefinition<Class> MARSHALLER_CLASS = AttributeDefinition.builder((String)"marshallerClass", null, Class.class).build();
    private final NearCacheConfiguration nearCache;
    private final Attribute<String> configuration;
    private final Attribute<Boolean> forceReturnValues;
    private final Attribute<Marshaller> marshaller;
    private final Attribute<Class> marshallerClass;
    private final Attribute<String> name;
    private final Attribute<String> templateName;
    private final Attribute<TransactionMode> transactionMode;
    private final Attribute<TransactionManagerLookup> transactionManager;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RemoteCacheConfiguration.class, new AttributeDefinition[]{CONFIGURATION, FORCE_RETURN_VALUES, NAME, MARSHALLER, MARSHALLER_CLASS, TEMPLATE_NAME, TRANSACTION_MODE, TRANSACTION_MANAGER});
    }

    RemoteCacheConfiguration(AttributeSet attributes, NearCacheConfiguration nearCache) {
        super("remote-cache", attributes, new ConfigurationElement[]{nearCache});
        this.nearCache = nearCache;
        this.configuration = attributes.attribute(CONFIGURATION);
        this.forceReturnValues = attributes.attribute(FORCE_RETURN_VALUES);
        this.name = attributes.attribute(NAME);
        this.marshaller = attributes.attribute(MARSHALLER);
        this.marshallerClass = attributes.attribute(MARSHALLER_CLASS);
        this.templateName = attributes.attribute(TEMPLATE_NAME);
        this.transactionMode = attributes.attribute(TRANSACTION_MODE);
        this.transactionManager = attributes.attribute(TRANSACTION_MANAGER);
    }

    public static RemoteCacheConfiguration fromCacheConfiguration(String name, CacheConfiguration cacheConfiguration) {
        RemoteCacheConfigurationBuilder builder = new RemoteCacheConfigurationBuilder(name);
        builder.configuration(cacheConfiguration.toString());
        return builder.create();
    }

    public static RemoteCacheConfiguration fromTemplate(String name, String template) {
        RemoteCacheConfigurationBuilder builder = new RemoteCacheConfigurationBuilder(name);
        builder.templateName(template);
        return builder.create();
    }

    public NearCacheConfiguration nearCache() {
        return this.nearCache;
    }

    public String configuration() {
        return (String)this.configuration.get();
    }

    public boolean forceReturnValues() {
        return (Boolean)this.forceReturnValues.get();
    }

    public String name() {
        return (String)this.name.get();
    }

    public Marshaller marshaller() {
        return (Marshaller)this.marshaller.get();
    }

    public Class<? extends Marshaller> marshallerClass() {
        return (Class)this.marshallerClass.get();
    }

    public String templateName() {
        return (String)this.templateName.get();
    }

    public TransactionMode transactionMode() {
        return (TransactionMode)((Object)this.transactionMode.get());
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return (TransactionManagerLookup)this.transactionManager.get();
    }
}

