/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.GetAllOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.ParallelHotRodOperation;

public class GetAllParallelOperation<K, V>
extends ParallelHotRodOperation<Map<K, V>, GetAllOperation<K, V>> {
    private final Set<byte[]> keys;

    protected GetAllParallelOperation(OperationContext operationContext, Set<byte[]> keys, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, options, dataFormat);
        this.keys = keys;
    }

    @Override
    protected List<GetAllOperation<K, V>> mapOperations() {
        HashMap<SocketAddress, Set> splittedKeys = new HashMap<SocketAddress, Set>();
        for (byte[] key : this.keys) {
            SocketAddress socketAddress = this.operationContext.getChannelFactory().getHashAwareServer(key, this.operationContext.getCacheNameBytes());
            Set keys = splittedKeys.computeIfAbsent(socketAddress, k -> new HashSet());
            keys.add(key);
        }
        return splittedKeys.values().stream().map(keysSubset -> new GetAllOperation(this.operationContext, (Set<byte[]>)keysSubset, (CacheOptions)this.options, this.dataFormat())).collect(Collectors.toList());
    }

    @Override
    protected Map<K, V> createCollector() {
        return new HashMap();
    }

    @Override
    protected void combine(Map<K, V> collector, Map<K, V> result) {
        collector.putAll(result);
    }
}

