/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.transaction.manager;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public final class RemoteXid
extends XidImpl {
    private static final int FORMAT_ID = 1213355096;
    private static final AtomicLong GLOBAL_ID_GENERATOR = new AtomicLong(1L);
    private static final AtomicLong BRANCH_QUALIFIER_GENERATOR = new AtomicLong(1L);

    private RemoteXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        super(formatId, globalTransactionId, branchQualifier);
    }

    public static RemoteXid create(UUID tmId) {
        long creationTime = System.currentTimeMillis();
        byte[] gid = RemoteXid.create(tmId, creationTime, GLOBAL_ID_GENERATOR);
        byte[] bid = RemoteXid.create(tmId, creationTime, BRANCH_QUALIFIER_GENERATOR);
        return new RemoteXid(1213355096, gid, bid);
    }

    private static void longToBytes(long val, byte[] array, int offset) {
        for (int i = 7; i > 0; --i) {
            array[offset + i] = (byte)val;
            val >>>= 8;
        }
        array[offset] = (byte)val;
    }

    private static byte[] create(UUID transactionManagerId, long creatingTime, AtomicLong generator) {
        byte[] field = new byte[32];
        RemoteXid.longToBytes(transactionManagerId.getLeastSignificantBits(), field, 0);
        RemoteXid.longToBytes(transactionManagerId.getMostSignificantBits(), field, 8);
        RemoteXid.longToBytes(creatingTime, field, 16);
        RemoteXid.longToBytes(generator.getAndIncrement(), field, 24);
        return field;
    }

    public void writeTo(ByteBuf byteBuf) {
        ByteBufUtil.writeSignedVInt(byteBuf, 1213355096);
        byte[] rawData = this.rawData();
        ByteBufUtil.writeArray(byteBuf, rawData, this.globalIdOffset(), this.globalIdLength());
        ByteBufUtil.writeArray(byteBuf, rawData, this.branchQualifierOffset(), this.branchQualifierLength());
    }

    public int estimateSize() {
        return ByteBufUtil.estimateVIntSize(1213355096) + this.globalIdLength() + this.branchQualifierLength();
    }
}

