/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.SecurityConfiguration;
import org.infinispan.hotrod.configuration.SslConfigurationBuilder;

public class SecurityConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<SecurityConfiguration> {
    private final AuthenticationConfigurationBuilder authentication;
    private final SslConfigurationBuilder ssl;

    SecurityConfigurationBuilder(HotRodConfigurationBuilder builder) {
        super(builder);
        this.authentication = new AuthenticationConfigurationBuilder(this.builder);
        this.ssl = new SslConfigurationBuilder(this.builder);
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.authentication.create(), this.ssl.create());
    }

    public Builder<?> read(SecurityConfiguration template) {
        this.authentication.read(template.authentication());
        this.ssl.read(template.ssl());
        return this;
    }

    public void validate() {
        this.authentication.validate();
        this.ssl.validate();
    }

    HotRodConfigurationBuilder getBuilder() {
        return this.builder;
    }
}

