/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.CacheEntryImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryMetadataImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.impl.iteration.KeyTracker;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class IterationNextOperation<K, E>
extends HotRodOperation<IterationNextResponse<K, E>> {
    private final byte[] iterationId;
    private final Channel channel;
    private final KeyTracker segmentKeyTracker;
    private byte[] finishedSegments;
    private int entriesSize = -1;
    private List<CacheEntry<K, E>> entries;
    private int projectionsSize;
    private int untrackedEntries;

    protected IterationNextOperation(OperationContext operationContext, CacheOptions options, byte[] iterationId, Channel channel, KeyTracker segmentKeyTracker, DataFormat dataFormat) {
        super(operationContext, (short)51, (short)52, options, dataFormat);
        this.iterationId = iterationId;
        this.channel = channel;
        this.segmentKeyTracker = segmentKeyTracker;
    }

    @Override
    public CompletableFuture<IterationNextResponse<K, E>> execute() {
        if (!this.channel.isActive()) {
            throw Log.HOTROD.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        this.scheduleRead(this.channel);
        this.sendArrayOperation(this.channel, this.iterationId);
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.entriesSize < 0) {
            this.finishedSegments = ByteBufUtil.readArray(buf);
            this.entriesSize = ByteBufUtil.readVInt(buf);
            if (this.entriesSize == 0) {
                IntSet finishedSegmentSet = IntSets.from((byte[])this.finishedSegments);
                this.segmentKeyTracker.segmentsFinished(finishedSegmentSet);
                this.complete(new IterationNextResponse(status, Collections.emptyList(), finishedSegmentSet, false));
                return;
            }
            this.entries = new ArrayList<CacheEntry<K, E>>(this.entriesSize);
            this.projectionsSize = this.operationContext.getCodec().readProjectionSize(buf);
            decoder.checkpoint();
        }
        while (this.entries.size() + this.untrackedEntries < this.entriesSize) {
            Object value;
            CacheEntryMetadataImpl metadata;
            short meta = this.operationContext.getCodec().readMeta(buf);
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if (meta == 1) {
                short flags = buf.readUnsignedByte();
                if ((flags & 1) != 1) {
                    creation = buf.readLong();
                    lifespan = ByteBufUtil.readVInt(buf);
                }
                if ((flags & 2) != 2) {
                    lastUsed = buf.readLong();
                    maxIdle = ByteBufUtil.readVInt(buf);
                }
                CacheEntryExpiration expiration = lifespan < 0 ? (maxIdle < 0 ? CacheEntryExpiration.IMMORTAL : CacheEntryExpiration.withMaxIdle((Duration)Duration.ofSeconds(maxIdle))) : (maxIdle < 0 ? CacheEntryExpiration.withLifespan((Duration)Duration.ofSeconds(lifespan)) : CacheEntryExpiration.withLifespanAndMaxIdle((Duration)Duration.ofSeconds(lifespan), (Duration)Duration.ofSeconds(maxIdle)));
                metadata = new CacheEntryMetadataImpl(creation, lastUsed, expiration, new CacheEntryVersionImpl(buf.readLong()));
            } else {
                metadata = new CacheEntryMetadataImpl();
            }
            byte[] key = ByteBufUtil.readArray(buf);
            if (this.projectionsSize > 1) {
                Object[] projections = new Object[this.projectionsSize];
                for (int j = 0; j < this.projectionsSize; ++j) {
                    projections[j] = this.unmarshallValue(ByteBufUtil.readArray(buf));
                }
                value = projections;
            } else {
                value = this.unmarshallValue(ByteBufUtil.readArray(buf));
            }
            if (this.segmentKeyTracker.track(key, status, this.operationContext.getConfiguration().getClassAllowList())) {
                Object unmarshallKey = this.dataFormat().keyToObj(key, this.operationContext.getConfiguration().getClassAllowList());
                this.entries.add(new CacheEntryImpl(unmarshallKey, value, metadata));
            } else {
                ++this.untrackedEntries;
            }
            decoder.checkpoint();
        }
        IntSet finishedSegmentSet = IntSets.from((byte[])this.finishedSegments);
        this.segmentKeyTracker.segmentsFinished(finishedSegmentSet);
        if (HotRodConstants.isInvalidIteration(status)) {
            throw Log.HOTROD.errorRetrievingNext(new String(this.iterationId, HOTROD_STRING_CHARSET));
        }
        this.complete(new IterationNextResponse<K, E>(status, this.entries, finishedSegmentSet, this.entriesSize > 0));
    }

    private <M> M unmarshallValue(byte[] bytes) {
        return (M)this.dataFormat().valueToObj(bytes, this.operationContext.getConfiguration().getClassAllowList());
    }
}

