/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class ContainsValueMultimapOperation
extends RetryOnFailureOperation<Boolean> {
    protected final byte[] value;
    private final boolean supportsDuplicates;

    protected ContainsValueMultimapOperation(OperationContext operationContext, int flags, byte[] value, CacheOptions options, boolean supportsDuplicates) {
        super(operationContext, (short)119, (short)120, options, null);
        this.value = value;
        this.supportsDuplicates = supportsDuplicates;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendValueOperation(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(Boolean.FALSE);
        } else {
            this.complete(buf.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void sendValueOperation(Channel channel) {
        CacheEntryExpiration.Impl expiration = (CacheEntryExpiration.Impl)((CacheWriteOptions)this.options).expiration();
        Codec codec = this.operationContext.getCodec();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + codec.estimateExpirationSize(expiration) + ByteBufUtil.estimateArraySize(this.value) + codec.estimateSizeMultimapSupportsDuplicated());
        codec.writeHeader(buf, this.header);
        codec.writeExpirationParams(buf, expiration);
        ByteBufUtil.writeArray(buf, this.value);
        codec.writeMultimapSupportDuplicates(buf, this.supportsDuplicates);
        channel.writeAndFlush((Object)buf);
    }
}

