/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.api.async.AsyncCache;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.AwaitAssertions;
import org.infinispan.hotrod.CacheEntryAssertions;
import org.infinispan.hotrod.impl.cache.CacheEntryImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.test.AbstractAsyncCacheSingleServerTest;
import org.infinispan.hotrod.test.KeyValueGenerator;
import org.infinispan.hotrod.util.FlowUtils;
import org.infinispan.hotrod.util.MapKVHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HotRodAsyncCacheTest<K, V>
extends AbstractAsyncCacheSingleServerTest<K, V> {
    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="getPut[{0}]")
    public void testPut(KeyValueGenerator<K, V> kvGenerator) {
        K key = kvGenerator.generateKey(this.cacheName, 0);
        V v1 = kvGenerator.generateValue(this.cacheName, 0);
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        CacheEntryVersionImpl version1 = new CacheEntryVersionImpl(1L);
        CacheEntryAssertions.assertEntry(key, null, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).put(key, v1, options)));
        kvGenerator.assertValueEquals(v1, AwaitAssertions.await(((AsyncCache)this.cache).get(key)));
        CacheEntryAssertions.assertEntry(key, v1, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)version1);
        CacheWriteOptions optionsV1 = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(20L)).lifespanAndMaxIdle(Duration.ofSeconds(25L), Duration.ofSeconds(30L)).build();
        CacheEntryVersionImpl version2 = new CacheEntryVersionImpl(2L);
        V v2 = kvGenerator.generateValue(this.cacheName, 1);
        CacheEntryAssertions.assertEntry(key, v1, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).put(key, v2, optionsV1)), options, (CacheEntryVersion)version1);
        CacheEntryAssertions.assertEntry(key, v2, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), optionsV1, (CacheEntryVersion)version2);
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testPutIfAbsent[{0}]")
    public void testPutIfAbsent(KeyValueGenerator<K, V> kvGenerator) {
        K key = kvGenerator.generateKey(this.cacheName, 0);
        V v1 = kvGenerator.generateValue(this.cacheName, 0);
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        CacheEntryVersionImpl version1 = new CacheEntryVersionImpl(1L);
        AwaitAssertions.assertAwaitEquals(null, ((AsyncCache)this.cache).putIfAbsent(key, v1, options));
        CacheEntryAssertions.assertEntry(key, v1, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)version1);
        V other = kvGenerator.generateValue(this.cacheName, 1);
        CacheEntry previousEntry = (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).putIfAbsent(key, other));
        kvGenerator.assertKeyEquals(key, previousEntry.key());
        kvGenerator.assertValueEquals(v1, previousEntry.value());
        kvGenerator.assertValueEquals(v1, AwaitAssertions.await(((AsyncCache)this.cache).get(key)));
        CacheEntryAssertions.assertEntry(key, v1, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)version1);
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testSetIfAbsent[{0}]")
    public void testSetIfAbsent(KeyValueGenerator<K, V> kvGenerator) {
        K key = kvGenerator.generateKey(this.cacheName, 0);
        V value = kvGenerator.generateValue(this.cacheName, 0);
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        AwaitAssertions.assertAwaitEquals(Boolean.valueOf(true), ((AsyncCache)this.cache).setIfAbsent(key, value, options));
        CacheEntryAssertions.assertEntry(key, value, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)new CacheEntryVersionImpl(1L));
        V other = kvGenerator.generateValue(this.cacheName, 1);
        AwaitAssertions.assertAwaitEquals(Boolean.valueOf(false), ((AsyncCache)this.cache).setIfAbsent(key, other));
        Object actual = AwaitAssertions.await(((AsyncCache)this.cache).get(key));
        kvGenerator.assertValueEquals(value, actual);
        CacheEntryAssertions.assertEntry(key, value, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)new CacheEntryVersionImpl(1L));
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testSet[{0}]")
    public void testSet(KeyValueGenerator<K, V> kvGenerator) {
        K key = kvGenerator.generateKey(this.cacheName, 0);
        V v1 = kvGenerator.generateValue(this.cacheName, 0);
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        CacheEntryVersionImpl version1 = new CacheEntryVersionImpl(1L);
        AwaitAssertions.await(((AsyncCache)this.cache).set(key, v1, options));
        CacheEntryAssertions.assertEntry(key, v1, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)version1);
        CacheWriteOptions optionsV2 = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(20L)).lifespanAndMaxIdle(Duration.ofSeconds(25L), Duration.ofSeconds(30L)).build();
        CacheEntryVersionImpl version2 = new CacheEntryVersionImpl(2L);
        V v2 = kvGenerator.generateValue(this.cacheName, 1);
        AwaitAssertions.await(((AsyncCache)this.cache).set(key, v2, optionsV2));
        Object actual = AwaitAssertions.await(((AsyncCache)this.cache).get(key));
        kvGenerator.assertValueEquals(v2, actual);
        CacheEntryAssertions.assertEntry(key, v2, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), optionsV2, (CacheEntryVersion)version2);
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testGetAndRemove[{0}]")
    public void testGetAndRemove(KeyValueGenerator<K, V> kvGenerator) {
        K key = kvGenerator.generateKey(this.cacheName, 0);
        V value = kvGenerator.generateValue(this.cacheName, 0);
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        CacheEntryVersionImpl cev = new CacheEntryVersionImpl(1L);
        CacheEntryAssertions.assertEntry(key, null, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).put(key, value, options)));
        CacheEntryAssertions.assertEntry(key, value, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)), options, (CacheEntryVersion)cev);
        CacheEntryAssertions.assertEntry(key, value, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getAndRemove(key)), options, (CacheEntryVersion)cev);
        AwaitAssertions.assertAwaitEquals(null, ((AsyncCache)this.cache).get(key));
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testPutAllAndClear[{0}]")
    public void testPutAllAndClear(KeyValueGenerator<K, V> kvGenerator) {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (int i = 0; i < 10; ++i) {
            K key = kvGenerator.generateKey(this.cacheName, i);
            V value = kvGenerator.generateValue(this.cacheName, i);
            entries.put(key, value);
        }
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        AwaitAssertions.await(((AsyncCache)this.cache).putAll(entries, options));
        CacheEntryVersionImpl cve = new CacheEntryVersionImpl(1L);
        for (Map.Entry entry : entries.entrySet()) {
            CacheEntryAssertions.assertEntry(entry.getKey(), entry.getValue(), kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(entry.getKey())), options, (CacheEntryVersion)cve);
        }
        AwaitAssertions.await(((AsyncCache)this.cache).clear());
        for (Map.Entry entry : entries.entrySet()) {
            AwaitAssertions.assertAwaitEquals(null, ((AsyncCache)this.cache).get(entry.getKey()));
        }
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testPutAllGetAll[{0}]")
    public void testPutAllGetAll(KeyValueGenerator<K, V> kvGenerator) {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (int i = 0; i < 10; ++i) {
            K key = kvGenerator.generateKey(this.cacheName, i);
            V value = kvGenerator.generateValue(this.cacheName, i);
            entries.put(key, value);
        }
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        AwaitAssertions.await(((AsyncCache)this.cache).putAll(entries, options));
        Flow.Publisher publisher = ((AsyncCache)this.cache).getAll(entries.keySet());
        Map<Object, CacheEntry> retrieved = FlowUtils.blockingCollect(publisher).stream().collect(Collectors.toMap(CacheEntry::key, e -> e));
        Assertions.assertEquals((int)entries.size(), (int)retrieved.size());
        MapKVHelper helper = new MapKVHelper(entries, kvGenerator);
        for (Map.Entry<Object, CacheEntry> entry : retrieved.entrySet()) {
            Object expected = helper.get(entry.getKey());
            Assertions.assertNotNull(expected);
            CacheEntryAssertions.assertEntry(entry.getKey(), expected, kvGenerator, entry.getValue());
        }
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testPutAllGetAndRemoveAll[{0}]")
    public void testPutAllGetAndRemoveAll(KeyValueGenerator<K, V> kvGenerator) {
        HashMap<K, V> entries = new HashMap<K, V>();
        SubmissionPublisher<CacheEntryImpl> entriesPublisher = new SubmissionPublisher<CacheEntryImpl>();
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        CompletionStage putAll = ((AsyncCache)this.cache).putAll(entriesPublisher, options);
        for (int i = 0; i < 10; ++i) {
            K key = kvGenerator.generateKey(this.cacheName, i);
            V value = kvGenerator.generateValue(this.cacheName, i);
            entries.put(key, value);
            entriesPublisher.submit(new CacheEntryImpl(key, value, null));
        }
        entriesPublisher.close();
        AwaitAssertions.await(putAll);
        Flow.Publisher publisher = ((AsyncCache)this.cache).getAndRemoveAll(entries.keySet());
        Map<Object, CacheEntry> retrieved = FlowUtils.blockingCollect(publisher).stream().collect(Collectors.toMap(CacheEntry::key, e -> e));
        Assertions.assertEquals((int)entries.size(), (int)retrieved.size());
        CacheEntryVersionImpl cve = new CacheEntryVersionImpl(1L);
        MapKVHelper helper = new MapKVHelper(entries, kvGenerator);
        for (Map.Entry<Object, CacheEntry> entry : retrieved.entrySet()) {
            Object expected = helper.get(entry.getKey());
            Assertions.assertNotNull(expected);
            CacheEntryAssertions.assertEntry(entry.getKey(), expected, kvGenerator, entry.getValue(), options, (CacheEntryVersion)cve);
        }
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            AwaitAssertions.assertAwaitEquals(null, ((AsyncCache)this.cache).get(entry.getKey()));
        }
        retrieved = FlowUtils.blockingCollect(((AsyncCache)this.cache).getAndRemoveAll(entries.keySet())).stream().collect(Collectors.toMap(CacheEntry::key, e -> e));
        Assertions.assertTrue((boolean)retrieved.isEmpty());
    }

    @MethodSource(value={"parameterized"})
    @ParameterizedTest(name="testReplace[{0}]")
    public void testReplace(KeyValueGenerator<K, V> kvGenerator) {
        K key = kvGenerator.generateKey(this.cacheName, 0);
        V initialValue = kvGenerator.generateValue(this.cacheName, 0);
        CacheWriteOptions options = CacheWriteOptions.writeOptions().timeout(Duration.ofSeconds(15L)).lifespanAndMaxIdle(Duration.ofSeconds(20L), Duration.ofSeconds(25L)).build();
        CacheEntryVersionImpl cve0 = new CacheEntryVersionImpl(0L);
        AwaitAssertions.assertAwaitEquals(Boolean.valueOf(false), ((AsyncCache)this.cache).replace(key, initialValue, (CacheEntryVersion)cve0));
        CacheEntryAssertions.assertEntry(key, null, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).put(key, initialValue, options)));
        CacheEntryAssertions.assertEntry(key, initialValue, kvGenerator, (CacheEntry)AwaitAssertions.await(((AsyncCache)this.cache).getEntry(key)));
        V replaceValue = kvGenerator.generateValue(this.cacheName, 1);
        CacheEntryVersionImpl cve2 = new CacheEntryVersionImpl(2L);
        AwaitAssertions.assertAwaitEquals(Boolean.valueOf(true), ((AsyncCache)this.cache).replace(key, replaceValue, (CacheEntryVersion)cve2));
        V anyValue = kvGenerator.generateValue(this.cacheName, 1);
        AwaitAssertions.assertAwaitEquals(Boolean.valueOf(false), ((AsyncCache)this.cache).replace(key, anyValue, (CacheEntryVersion)cve0));
    }

    public Stream<Arguments> parameterized() {
        return Stream.of(Arguments.of((Object[])new Object[]{KeyValueGenerator.BYTE_ARRAY_GENERATOR}), Arguments.of((Object[])new Object[]{KeyValueGenerator.STRING_GENERATOR}), Arguments.of((Object[])new Object[]{KeyValueGenerator.GENERIC_ARRAY_GENERATOR}));
    }
}

