/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.test;

import org.infinispan.test.TestingUtil;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public interface KeyValueGenerator<K, V> {
    public static final KeyValueGenerator<String, String> STRING_GENERATOR = new KeyValueGenerator<String, String>(){

        @Override
        public String generateKey(String method, int index) {
            return TestingUtil.k((String)method, (int)index);
        }

        @Override
        public String generateValue(String method, int index) {
            return TestingUtil.v((String)method, (int)index);
        }

        @Override
        public void assertValueEquals(String expected, String actual) {
            Assertions.assertEquals((Object)expected, (Object)actual);
        }

        @Override
        public void assertKeyEquals(String expected, String actual) {
            Assertions.assertEquals((Object)expected, (Object)actual);
        }

        public String toString() {
            return "STRING";
        }
    };
    public static final KeyValueGenerator<byte[], byte[]> BYTE_ARRAY_GENERATOR = new KeyValueGenerator<byte[], byte[]>(){

        @Override
        public byte[] generateKey(String method, int index) {
            return TestingUtil.k((String)method, (int)index).getBytes();
        }

        @Override
        public byte[] generateValue(String method, int index) {
            return TestingUtil.v((String)method, (int)index).getBytes();
        }

        @Override
        public void assertValueEquals(byte[] expected, byte[] actual) {
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }

        @Override
        public void assertKeyEquals(byte[] expected, byte[] actual) {
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }

        public String toString() {
            return "BYTE_ARRAY";
        }
    };
    public static final KeyValueGenerator<Object[], Object[]> GENERIC_ARRAY_GENERATOR = new KeyValueGenerator<Object[], Object[]>(){

        @Override
        public Object[] generateKey(String method, int index) {
            return new Object[]{method, "key", index};
        }

        @Override
        public Object[] generateValue(String method, int index) {
            return new Object[]{method, "value", index};
        }

        @Override
        public void assertValueEquals(Object[] expected, Object[] actual) {
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        }

        @Override
        public void assertKeyEquals(Object[] expected, Object[] actual) {
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        }

        public String toString() {
            return "GENERIC_ARRAY";
        }
    };

    public K generateKey(String var1, int var2);

    public V generateValue(String var1, int var2);

    public void assertValueEquals(V var1, V var2);

    public void assertKeyEquals(K var1, K var2);

    default public boolean equalKeys(K expected, K actual) {
        try {
            this.assertKeyEquals(expected, actual);
            return true;
        }
        catch (AssertionFailedError ignore) {
            return false;
        }
    }

    default public void assertValueNotEquals(V expected, V actual) {
        try {
            this.assertValueEquals(expected, actual);
        }
        catch (AssertionFailedError ignore) {
            return;
        }
        Assertions.fail((String)"Value should be different");
    }
}

