/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.mutiny.MutinyCache;
import org.infinispan.api.mutiny.MutinyCaches;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.HotRodMutinyCache;

public class HotRodMutinyCaches
implements MutinyCaches {
    private final HotRod hotrod;

    HotRodMutinyCaches(HotRod hotrod) {
        this.hotrod = hotrod;
    }

    public <K, V> Uni<MutinyCache<K, V>> create(String name, CacheConfiguration cacheConfiguration) {
        return Uni.createFrom().completionStage(() -> this.hotrod.transport.getRemoteCache(name)).map(r -> new HotRodMutinyCache(this.hotrod, r));
    }

    public <K, V> Uni<MutinyCache<K, V>> create(String name, String template) {
        return Uni.createFrom().completionStage(() -> this.hotrod.transport.getRemoteCache(name)).map(r -> new HotRodMutinyCache(this.hotrod, r));
    }

    public <K, V> Uni<MutinyCache<K, V>> get(String name) {
        return Uni.createFrom().completionStage(() -> this.hotrod.transport.getRemoteCache(name)).map(r -> new HotRodMutinyCache(this.hotrod, r));
    }

    public Uni<Void> remove(String name) {
        return Uni.createFrom().completionStage(() -> this.hotrod.transport.removeCache(name));
    }

    public Multi<String> names() {
        return Multi.createFrom().deferred(() -> this.toMulti(this.hotrod.transport.getCacheNames()));
    }

    public Uni<Void> createTemplate(String name, CacheConfiguration cacheConfiguration) {
        return null;
    }

    public Uni<Void> removeTemplate(String name) {
        return null;
    }

    public Multi<String> templateNames() {
        return Multi.createFrom().deferred(() -> this.toMulti(this.hotrod.transport.getTemplateNames()));
    }

    private Multi<String> toMulti(CompletionStage<Set<String>> cs) {
        return Multi.createFrom().completionStage(cs).onItem().transformToIterable(Function.identity());
    }
}

